/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.ssl;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.restlet.test.ext.ssl.SslBaseConnectorsTestCase;

public class SslClientContextGetTestCase
extends SslBaseConnectorsTestCase {
    protected void call(String uri) throws Exception {
        Request request = new Request(Method.GET, uri);
        Client client = new Client(Protocol.HTTPS);
        if (client.getContext() == null) {
            client.setContext(new Context());
        }
        this.configureSslServerParameters(client.getContext());
        Response r = client.handle(request);
        SslClientContextGetTestCase.assertEquals((String)r.getStatus().getDescription(), (Object)Status.SUCCESS_OK, (Object)r.getStatus());
        SslClientContextGetTestCase.assertEquals((String)"Hello world", (String)r.getEntity().getText());
        Thread.sleep(200L);
        client.stop();
    }

    protected Application createApplication(Component component) {
        Application application = new Application(){

            public Restlet createInboundRoot() {
                Router router = new Router(this.getContext());
                router.attach("/test", GetTestResource.class);
                return router;
            }
        };
        return application;
    }

    public static class GetTestResource
    extends ServerResource {
        public GetTestResource() {
            this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        }

        public Representation get(Variant variant) {
            return new StringRepresentation((CharSequence)"Hello world", MediaType.TEXT_PLAIN);
        }
    }
}

