/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.restlet.Component;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.ext.xml.Transformer;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class TransformerTestCase
extends RestletTestCase {
    final String output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><buyer>cust123</buyer>23.45";
    final Representation source = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><purchase id=\"p001\"><customer db=\"cust123\"/><product db=\"prod345\"><amount>23.45</amount></product></purchase>", MediaType.TEXT_XML);
    final Representation xslt = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><xsl:transform xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:template match =\"customer\"><buyer><xsl:value-of select=\"@db\"/></buyer></xsl:template></xsl:transform>", MediaType.TEXT_XML);

    public static void main(String[] args) {
        try {
            new TransformerTestCase().testTransform();
            new TransformerTestCase().parallelTestTransform();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parallelTestTransform() throws Exception {
        Component comp = new Component();
        final TransformRepresentation tr = new TransformRepresentation(comp.getContext(), this.source, this.xslt);
        final FailureTracker tracker = new FailureTracker();
        int testVolume = 5000;
        Thread[] parallelTransform = new Thread[5000];
        for (int i = 0; i < parallelTransform.length; ++i) {
            final int index = i;
            parallelTransform[i] = new Thread(){

                public void run() {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        tr.write((OutputStream)out);
                        String result = out.toString();
                        Assert.assertEquals((String)TransformerTestCase.this.output, (String)result);
                        out.close();
                    }
                    catch (Throwable e) {
                        tracker.trackFailure("Exception during write in thread ", index, e);
                    }
                }
            };
        }
        for (Thread pt : parallelTransform) {
            pt.start();
        }
        tracker.report();
    }

    public void testTransform() throws Exception {
        Transformer transformer = new Transformer(1, this.xslt);
        String result = transformer.transform(this.source).getText();
        TransformerTestCase.assertEquals((String)this.output, (String)result);
    }

    class FailureTracker {
        boolean allOk = true;
        final StringBuffer trackedMessages = new StringBuffer();

        FailureTracker() {
        }

        void report() {
            if (!this.allOk) {
                Assert.fail((String)("TRACKER REPORT: \n" + this.trackedMessages.toString()));
            }
        }

        void trackFailure(String message) {
            System.err.println(message);
            this.trackedMessages.append(message + "\n");
            this.allOk = false;
        }

        void trackFailure(String message, int index, Throwable e) {
            e.printStackTrace();
            this.trackFailure(message + " " + index + ": " + e.getMessage());
        }
    }
}

