/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.jaxrs.services.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;
import org.restlet.test.jaxrs.server.RestletServerTestCase;
import org.restlet.test.jaxrs.util.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxRsTestCase
extends RestletServerTestCase {
    public static void assertAllowedMethod(Response optionsResponse, Method ... methods) {
        HashSet<Method> expectedMethods;
        if (optionsResponse.getStatus().isError()) {
            JaxRsTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)optionsResponse.getStatus());
        }
        if ((expectedMethods = new HashSet<Method>(Arrays.asList(methods))).contains(Method.GET)) {
            expectedMethods.add(Method.HEAD);
        }
        ArrayList allowedMethods = new ArrayList(optionsResponse.getAllowedMethods());
        for (Method method : methods) {
            JaxRsTestCase.assertTrue((String)("allowedMethod must contain " + method), (boolean)allowedMethods.contains(method));
        }
        JaxRsTestCase.assertEquals((String)"allowedMethods.size invalid", (int)expectedMethods.size(), (int)allowedMethods.size());
    }

    public static void assertEmptyEntity(Response response) throws IOException {
        if (response.getEntity() != null) {
            JaxRsTestCase.assertEquals(null, (String)response.getEntity().getText());
        }
    }

    public static void assertEqualMediaType(MediaType expected, MediaType actual) {
        expected = Converter.getMediaTypeWithoutParams((MediaType)expected);
        actual = Converter.getMediaTypeWithoutParams((MediaType)actual);
        JaxRsTestCase.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEqualMediaType(MediaType expected, Representation actualEntity) {
        if (actualEntity == null) {
            JaxRsTestCase.fail((String)"The entity must not be null, if a media type should be read");
        }
        JaxRsTestCase.assertEqualMediaType(expected, actualEntity.getMediaType());
    }

    public static void assertEqualMediaType(MediaType expected, Response actualResponse) {
        if (actualResponse == null) {
            JaxRsTestCase.fail((String)"The response must not be null, if an entity should be read");
        }
        JaxRsTestCase.assertEqualMediaType(expected, actualResponse.getEntity());
    }

    public static Collection<Preference<MediaType>> createPrefColl(MediaType accMediaType, float mediaTypeQuality) {
        if (accMediaType == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(new Preference((Metadata)accMediaType, mediaTypeQuality));
    }

    public static boolean jaxRxImplementorCheck(int dayOfMonth, int month) {
        return JaxRsTestCase.jaxRxImplementorCheck(dayOfMonth, month, 2009);
    }

    public static boolean jaxRxImplementorCheck(int dayOfMonth, int month, int year) {
        Date afterDate = new Date(year - 1900, month - 1, dayOfMonth);
        if (new Date().after(afterDate)) {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                return true;
            }
            if (userHome.equals("C:\\Dokumente und Einstellungen\\Stephan")) {
                String javaClassPath = System.getProperty("java.class.path");
                if (javaClassPath == null) {
                    return true;
                }
                if (javaClassPath.startsWith("D:\\eclipse-workspaces\\Mastera")) {
                    return false;
                }
            }
        }
        return true;
    }

    public Response accessServer(Method httpMethod) {
        return this.accessServer(httpMethod, this.getRootResourceClassFromAppConf(), null);
    }

    public Response accessServer(Method httpMethod, Class<?> klasse, Collection acceptedMediaTypes) throws IllegalArgumentException {
        return this.accessServer(httpMethod, klasse, null, acceptedMediaTypes, null);
    }

    public Response accessServer(Method httpMethod, Class<?> klasse, String subPath, Collection accMediaTypes, ChallengeResponse challengeResponse) {
        Reference reference = this.createReference(klasse, subPath);
        return this.accessServer(httpMethod, reference, accMediaTypes, null, challengeResponse, null, null, null);
    }

    public Response accessServer(Method httpMethod, Class<?> klasse, String subPath, Conditions conditions, ClientInfo clientInfo) {
        Reference reference = this.createReference(klasse, subPath);
        Request request = new Request(httpMethod, reference);
        if (conditions != null) {
            request.setConditions(conditions);
        }
        if (clientInfo != null) {
            request.setClientInfo(clientInfo);
        }
        return this.accessServer(request);
    }

    public Response accessServer(Method httpMethod, Class<?> klasse, String subPath, MediaType accMediaType) {
        Set<MediaType> mediaTypes = null;
        if (accMediaType != null) {
            mediaTypes = Collections.singleton(accMediaType);
        }
        return this.accessServer(httpMethod, klasse, subPath, mediaTypes, null);
    }

    @Override
    protected Application createApplication() {
        return this.createApplication(this.getApplication(), ChallengeScheme.HTTP_BASIC);
    }

    protected JaxRsApplication createApplication(javax.ws.rs.core.Application appConfig, ChallengeScheme challengeScheme) {
        JaxRsApplication application = new JaxRsApplication(new Context());
        application.add(appConfig);
        this.modifyApplication(application);
        return application;
    }

    protected void modifyApplication(JaxRsApplication application) {
    }

    protected Request createGetRequest(String subPath) {
        Reference reference = this.createReference(this.getRootResourceClassFromAppConf(), subPath);
        return new Request(Method.GET, reference);
    }

    public Reference createReference(Class<?> jaxRsClass, String subPath) {
        String path;
        try {
            path = Util.getPathTemplateWithoutRegExps(jaxRsClass);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.createReference(path, subPath);
    }

    public Reference createReference(String subPath) {
        return this.createReference(this.getRootResourceClassFromAppConf(), subPath);
    }

    public Reference createReference(String path, String subPath) {
        Reference reference = this.createBaseRef();
        reference.setBaseRef(this.createBaseRef());
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (subPath != null) {
            if (subPath.startsWith(";")) {
                path = path + subPath;
            } else if (subPath.length() > 0) {
                path = path.endsWith("/") || subPath.startsWith("/") ? path + subPath : path + "/" + subPath;
            }
        }
        reference.setPath(path);
        return reference;
    }

    public Response get() {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), null, null);
    }

    public Response get(Cookie cookie) {
        return this.get(null, cookie);
    }

    public Response get(MediaType accMediaType) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), null, accMediaType);
    }

    public Response get(Reference reference) {
        return this.accessServer(Method.GET, reference);
    }

    public Response get(Reference reference, MediaType mediaType) {
        ArrayList<MediaType> mediaTypes = null;
        if (mediaType != null) {
            mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(mediaType);
        }
        return this.accessServer(Method.GET, reference, mediaTypes, null, null, null, null, null);
    }

    public Response get(String subPath) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), subPath, null);
    }

    public Response get(String subPath, ChallengeResponse cr) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), subPath, null, cr);
    }

    public Response get(String subPath, ClientInfo clientInfo) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), subPath, null, clientInfo);
    }

    public Response get(String subPath, Conditions conditions) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), subPath, conditions, null);
    }

    public Response get(String subPath, Cookie cookie) {
        return this.accessServer(Method.GET, this.createReference(this.getRootResourceClassFromAppConf(), subPath), null, null, null, null, TestUtils.createList(cookie), null);
    }

    public Response get(String subPath, MediaType accMediaType) {
        return this.accessServer(Method.GET, this.getRootResourceClassFromAppConf(), subPath, accMediaType);
    }

    protected abstract javax.ws.rs.core.Application getApplication();

    public Response getAuth(String subPath, String username, String password) {
        return this.get(subPath, new ChallengeResponse(ChallengeScheme.HTTP_BASIC, username, password));
    }

    private Class<?> getRootResourceClassFromAppConf() throws IllegalStateException {
        Set classes = this.getApplication().getClasses();
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(Path.class)) continue;
            return clazz;
        }
        Set singletons = this.getApplication().getSingletons();
        for (Object singleton : singletons) {
            Class<?> clazz = singleton.getClass();
            if (!clazz.isAnnotationPresent(Path.class)) continue;
            return clazz;
        }
        throw new IllegalStateException("Sorry, no root resource class found");
    }

    public Response getWithCookies(String subPath, Collection<Cookie> cookies) {
        return this.accessServer(Method.GET, this.createReference(this.getRootResourceClassFromAppConf(), subPath), null, null, null, null, cookies, null);
    }

    public Response getWithHeaders(String subPath, Collection<Parameter> headers) {
        return this.accessServer(Method.GET, this.createReference(this.getRootResourceClassFromAppConf(), subPath), null, null, null, null, null, headers);
    }

    public Response head(String subPath, MediaType accMediaType) {
        return this.accessServer(Method.HEAD, this.getRootResourceClassFromAppConf(), subPath, accMediaType);
    }

    public Response options() {
        return this.accessServer(Method.OPTIONS, this.getRootResourceClassFromAppConf(), null, null);
    }

    public Response options(String subPath) {
        return this.accessServer(Method.OPTIONS, this.getRootResourceClassFromAppConf(), subPath, null);
    }

    public Response post(Representation entity) {
        return this.post(null, entity, null, null);
    }

    public Response post(String subPath, MediaType mediaType) {
        return this.accessServer(Method.POST, this.getRootResourceClassFromAppConf(), subPath, mediaType);
    }

    public Response post(String subPath, Representation entity) {
        return this.post(subPath, entity, null);
    }

    public Response post(String subPath, Representation entity, ChallengeResponse cr) {
        return this.accessServer(Method.POST, this.createReference(this.getRootResourceClassFromAppConf(), subPath), null, entity, cr, null, null, null);
    }

    public Response post(String subPath, Representation entity, Collection accMediaTypes, ChallengeResponse challengeResponse) {
        return this.accessServer(Method.POST, this.createReference(this.getRootResourceClassFromAppConf(), subPath), accMediaTypes, entity, challengeResponse, null, null, null);
    }

    public Response put(String subPath, Representation entity) {
        return this.put(subPath, entity, null);
    }

    public Response put(String subPath, Representation entity, Conditions conditions) {
        return this.accessServer(Method.PUT, this.createReference(this.getRootResourceClassFromAppConf(), subPath), null, entity, null, conditions, null, null);
    }

    @Override
    protected void runServerAfterStart() {
        javax.ws.rs.core.Application appConfig = this.getApplication();
        Set rrcs = appConfig.getClasses();
        System.out.println("the root resource classes are available under the following pathes:");
        for (Class rrc : rrcs) {
            try {
                System.out.print("http://localhost:" + this.getServerPort());
                String path = rrc.getAnnotation(Path.class).value();
                if (!path.startsWith("/")) {
                    System.out.print("/");
                }
                System.out.println(path);
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void runServerUntilKeyPressed() throws Exception {
        JaxRsTestCase.setUseTcp(true);
        this.startServer(this.createApplication());
        this.runServerAfterStart();
        System.out.println("press key to stop . . .");
        System.in.read();
        this.stopServer();
        System.out.println("server stopped");
    }

    private void startServer(javax.ws.rs.core.Application application, Protocol protocol, ChallengeScheme challengeScheme) throws Exception {
        JaxRsApplication jaxRsApplication = this.createApplication(application, challengeScheme);
        this.startServer((Application)jaxRsApplication, protocol);
    }

    protected void startServer(ChallengeScheme challengeScheme) throws Exception {
        javax.ws.rs.core.Application appConfig = this.getApplication();
        this.startServer(appConfig, Protocol.HTTP, challengeScheme);
    }
}

