/**
 * Copyright 2005-2013 Restlet S.A.S.
 * 
 * The contents of this file are subject to the terms of one of the following
 * open source licenses: Apache 2.0 or LGPL 3.0 or LGPL 2.1 or CDDL 1.0 or EPL
 * 1.0 (the "Licenses"). You can select the license that you prefer but you may
 * not use this file except in compliance with one of these Licenses.
 * 
 * You can obtain a copy of the Apache 2.0 license at
 * http://www.opensource.org/licenses/apache-2.0
 * 
 * You can obtain a copy of the LGPL 3.0 license at
 * http://www.opensource.org/licenses/lgpl-3.0
 * 
 * You can obtain a copy of the LGPL 2.1 license at
 * http://www.opensource.org/licenses/lgpl-2.1
 * 
 * You can obtain a copy of the CDDL 1.0 license at
 * http://www.opensource.org/licenses/cddl1
 * 
 * You can obtain a copy of the EPL 1.0 license at
 * http://www.opensource.org/licenses/eclipse-1.0
 * 
 * See the Licenses for the specific language governing permissions and
 * limitations under the Licenses.
 * 
 * Alternatively, you can obtain a royalty free commercial license with less
 * limitations, transferable or non-transferable, directly at
 * http://www.restlet.com/products/restlet-framework
 * 
 * Restlet is a registered trademark of Restlet S.A.S.
 */

package org.restlet.test.ext.odata.deepexpand.model;


import java.util.Date;
import java.util.List;

import org.restlet.test.ext.odata.deepexpand.model.CoOp;
import org.restlet.test.ext.odata.deepexpand.model.Invitation;
import org.restlet.test.ext.odata.deepexpand.model.Job;
import org.restlet.test.ext.odata.deepexpand.model.Professor;
import org.restlet.test.ext.odata.deepexpand.model.Registration;
import org.restlet.test.ext.odata.deepexpand.model.Report;

/**
* Generated by the generator tool for the OData extension for the Restlet framework.<br>
*
* @see <a href="http://praktiki.metal.ntua.gr/CoopOData/CoopOData.svc/$metadata">Metadata of the target OData service</a>
*
*/
public class Group {

    private String comments;
    private double grade;
    private Date gradeDate;
    private int id;
    private boolean isPendingFormation;
    private boolean passed;
    private Tracking tracking;
    private CoOp coOp;
    private List<Invitation> invitations;
    private Job job;
    private List<Registration> registrations;
    private List<Report> reports;
    private List<Professor> supervisingProfessors;

    /**
     * Constructor without parameter.
     * 
     */
    public Group() {
        super();
    }

    /**
     * Constructor.
     * 
     * @param id
     *            The identifiant value of the entity.
     */
    public Group(int id) {
        this();
        this.id = id;
    }

   /**
    * Returns the value of the "comments" attribute.
    *
    * @return The value of the "comments" attribute.
    */
   public String getComments() {
      return comments;
   }
   /**
    * Returns the value of the "grade" attribute.
    *
    * @return The value of the "grade" attribute.
    */
   public double getGrade() {
      return grade;
   }
   /**
    * Returns the value of the "gradeDate" attribute.
    *
    * @return The value of the "gradeDate" attribute.
    */
   public Date getGradeDate() {
      return gradeDate;
   }
   /**
    * Returns the value of the "id" attribute.
    *
    * @return The value of the "id" attribute.
    */
   public int getId() {
      return id;
   }
   /**
    * Returns the value of the "isPendingFormation" attribute.
    *
    * @return The value of the "isPendingFormation" attribute.
    */
   public boolean getIsPendingFormation() {
      return isPendingFormation;
   }
   /**
    * Returns the value of the "passed" attribute.
    *
    * @return The value of the "passed" attribute.
    */
   public boolean getPassed() {
      return passed;
   }
   /**
    * Returns the value of the "tracking" attribute.
    *
    * @return The value of the "tracking" attribute.
    */
   public Tracking getTracking() {
      return tracking;
   }
   /**
    * Returns the value of the "coOp" attribute.
    *
    * @return The value of the "coOp" attribute.
    */
   public CoOp getCoOp() {
      return coOp;
   }
   
   /**
    * Returns the value of the "invitations" attribute.
    *
    * @return The value of the "invitations" attribute.
    */
   public List<Invitation> getInvitations() {
      return invitations;
   }
   
   /**
    * Returns the value of the "job" attribute.
    *
    * @return The value of the "job" attribute.
    */
   public Job getJob() {
      return job;
   }
   
   /**
    * Returns the value of the "registrations" attribute.
    *
    * @return The value of the "registrations" attribute.
    */
   public List<Registration> getRegistrations() {
      return registrations;
   }
   
   /**
    * Returns the value of the "reports" attribute.
    *
    * @return The value of the "reports" attribute.
    */
   public List<Report> getReports() {
      return reports;
   }
   
   /**
    * Returns the value of the "supervisingProfessors" attribute.
    *
    * @return The value of the "supervisingProfessors" attribute.
    */
   public List<Professor> getSupervisingProfessors() {
      return supervisingProfessors;
   }
   
   /**
    * Sets the value of the "comments" attribute.
    *
    * @param comments
    *     The value of the "comments" attribute.
    */
   public void setComments(String comments) {
      this.comments = comments;
   }
   /**
    * Sets the value of the "grade" attribute.
    *
    * @param grade
    *     The value of the "grade" attribute.
    */
   public void setGrade(double grade) {
      this.grade = grade;
   }
   /**
    * Sets the value of the "gradeDate" attribute.
    *
    * @param gradeDate
    *     The value of the "gradeDate" attribute.
    */
   public void setGradeDate(Date gradeDate) {
      this.gradeDate = gradeDate;
   }
   /**
    * Sets the value of the "id" attribute.
    *
    * @param id
    *     The value of the "id" attribute.
    */
   public void setId(int id) {
      this.id = id;
   }
   /**
    * Sets the value of the "isPendingFormation" attribute.
    *
    * @param isPendingFormation
    *     The value of the "isPendingFormation" attribute.
    */
   public void setIsPendingFormation(boolean isPendingFormation) {
      this.isPendingFormation = isPendingFormation;
   }
   /**
    * Sets the value of the "passed" attribute.
    *
    * @param passed
    *     The value of the "passed" attribute.
    */
   public void setPassed(boolean passed) {
      this.passed = passed;
   }
   /**
    * Sets the value of the "tracking" attribute.
    *
    * @param tracking
    *     The value of the "tracking" attribute.
    */
   public void setTracking(Tracking tracking) {
      this.tracking = tracking;
   }
   
   /**
    * Sets the value of the "coOp" attribute.
    *
    * @param coOp"
    *     The value of the "coOp" attribute.
    */
   public void setCoOp(CoOp coOp) {
      this.coOp = coOp;
   }

   /**
    * Sets the value of the "invitations" attribute.
    *
    * @param invitations"
    *     The value of the "invitations" attribute.
    */
   public void setInvitations(List<Invitation> invitations) {
      this.invitations = invitations;
   }

   /**
    * Sets the value of the "job" attribute.
    *
    * @param job"
    *     The value of the "job" attribute.
    */
   public void setJob(Job job) {
      this.job = job;
   }

   /**
    * Sets the value of the "registrations" attribute.
    *
    * @param registrations"
    *     The value of the "registrations" attribute.
    */
   public void setRegistrations(List<Registration> registrations) {
      this.registrations = registrations;
   }

   /**
    * Sets the value of the "reports" attribute.
    *
    * @param reports"
    *     The value of the "reports" attribute.
    */
   public void setReports(List<Report> reports) {
      this.reports = reports;
   }

   /**
    * Sets the value of the "supervisingProfessors" attribute.
    *
    * @param supervisingProfessors"
    *     The value of the "supervisingProfessors" attribute.
    */
   public void setSupervisingProfessors(List<Professor> supervisingProfessors) {
      this.supervisingProfessors = supervisingProfessors;
   }

}