/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Warning;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private volatile Map<String, Object> attributes = null;
    private volatile List<CacheDirective> cacheDirectives = null;
    private volatile Representation entity;
    private volatile Form entityForm;
    private volatile String entityText;
    private volatile Uniform onSent;
    private volatile List<Warning> warnings;
    private volatile Date date = null;

    public Message() {
        this(null);
    }

    public Message(Representation entity) {
        this.entity = entity;
        this.entityForm = null;
        this.entityText = null;
        this.onSent = null;
        this.warnings = null;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Object>();
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CacheDirective> getCacheDirectives() {
        List<CacheDirective> r = this.cacheDirectives;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.cacheDirectives;
                if (r == null) {
                    this.cacheDirectives = r = new CopyOnWriteArrayList<CacheDirective>();
                }
            }
        }
        return r;
    }

    public Date getDate() {
        return this.date;
    }

    public Representation getEntity() {
        return this.entity;
    }

    @Deprecated
    public Form getEntityAsForm() {
        if (this.entityForm == null) {
            this.entityForm = new Form(this.getEntity());
        }
        return this.entityForm;
    }

    public String getEntityAsText() {
        if (this.entityText == null) {
            try {
                this.entityText = this.getEntity().getText();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.FINE, "Unable to get the entity text.", e);
            }
        }
        return this.entityText;
    }

    public Uniform getOnSent() {
        return this.onSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Warning> getWarnings() {
        List<Warning> r = this.warnings;
        if (r == null) {
            Message message = this;
            synchronized (message) {
                r = this.warnings;
                if (r == null) {
                    this.warnings = r = new CopyOnWriteArrayList<Warning>();
                }
            }
        }
        return r;
    }

    public abstract boolean isConfidential();

    public boolean isEntityAvailable() {
        boolean result = this.getEntity() != null && this.getEntity().isAvailable();
        return result;
    }

    public void release() {
        if (this.getEntity() != null) {
            this.getEntity().release();
        }
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setCacheDirectives(List<CacheDirective> cacheDirectives) {
        this.cacheDirectives = cacheDirectives;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setEntity(Representation entity) {
        this.entity = entity;
    }

    public void setEntity(String value, MediaType mediaType) {
        this.setEntity(new StringRepresentation((CharSequence)value, mediaType));
    }

    public void setOnSent(Uniform onSentCallback) {
        this.onSent = onSentCallback;
    }

    public void setWarnings(List<Warning> warnings) {
        this.warnings = warnings;
    }
}

