/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.io;

import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class ClosingRepresentation
extends WrapperRepresentation {
    private final Logger logger;
    private final Socket socket;

    public ClosingRepresentation(Representation wrappedRepresentation, Socket socket, Logger logger) {
        super(wrappedRepresentation);
        this.socket = socket;
        this.logger = logger;
    }

    public void release() {
        try {
            if (!this.socket.isClosed()) {
                if (!(this.socket instanceof SSLSocket)) {
                    this.socket.shutdownOutput();
                }
                this.socket.close();
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "An error occured closing the client socket", ex);
        }
        super.release();
    }
}

