/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jibx;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.restlet.data.MediaType;
import org.restlet.resource.Representation;
import org.restlet.resource.XmlRepresentation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JibxRepresentation<T>
extends XmlRepresentation {
    private static final Map<String, IBindingFactory> bindingFactories = new TreeMap<String, IBindingFactory>();
    private volatile Class bindingClass;
    private volatile String bindingName;
    private volatile String encoding = "UTF-8";
    private volatile T object;
    private volatile Representation xmlRepresentation;

    private static synchronized IBindingFactory getBindingFactory(String bindingName, Class bindingClass) throws JiBXException {
        IBindingFactory jibxBFact = bindingFactories.get(bindingName + bindingClass.toString());
        if (jibxBFact == null) {
            jibxBFact = bindingName == null ? BindingDirectory.getFactory((Class)bindingClass) : BindingDirectory.getFactory((String)bindingName, (Class)bindingClass);
            bindingFactories.put(bindingName + bindingClass.toString(), jibxBFact);
        }
        return jibxBFact;
    }

    public JibxRepresentation(MediaType mediaType, T object) {
        this(mediaType, object, null);
    }

    public JibxRepresentation(MediaType mediaType, T object, String bindingName) {
        super(mediaType);
        this.object = object;
        this.bindingClass = object.getClass();
        this.bindingName = bindingName;
    }

    public JibxRepresentation(Representation xmlRepresentation, Class bindingClass) {
        this(xmlRepresentation, bindingClass, null);
    }

    public JibxRepresentation(Representation xmlRepresentation, Class bindingClass, String bindingName) {
        super(xmlRepresentation.getMediaType());
        this.xmlRepresentation = xmlRepresentation;
        this.bindingClass = bindingClass;
        this.bindingName = bindingName;
    }

    public Object evaluate(String expression, QName returnType) throws Exception {
        Object result = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)((Object)this));
        Document xmlDocument = this.getDocumentBuilder().parse(this.xmlRepresentation.getStream());
        if (xmlDocument == null) {
            throw new Exception("Unable to obtain a DOM document for the XML representation. XPath evaluation cancelled.");
        }
        result = xpath.evaluate(expression, xmlDocument, returnType);
        return result;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public T getObject() throws JiBXException, IOException {
        if (this.object == null && this.xmlRepresentation != null) {
            IBindingFactory jibxBFact = JibxRepresentation.getBindingFactory(this.bindingName, this.bindingClass);
            IUnmarshallingContext uctx = jibxBFact.createUnmarshallingContext();
            return (T)uctx.unmarshalDocument(this.xmlRepresentation.getStream(), null);
        }
        return this.object;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            IBindingFactory jibxBFact = JibxRepresentation.getBindingFactory(this.bindingName, this.bindingClass);
            IMarshallingContext mctx = jibxBFact.createMarshallingContext();
            mctx.marshalDocument(this.getObject(), this.encoding, null, outputStream);
        }
        catch (JiBXException e) {
            throw new IOException(e.getMessage());
        }
    }
}

