/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.List;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.FaultInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.resource.Variant;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends DocumentedInfo {
    private String identifier;
    private Method name;
    private RequestInfo request;
    private ResponseInfo response;
    private Reference targetRef;

    public MethodInfo() {
    }

    public MethodInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public MethodInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public MethodInfo(String documentation) {
        super(documentation);
    }

    public FaultInfo addFault(Status status, MediaType mediaType, String documentation) {
        FaultInfo result = new FaultInfo(status, mediaType, documentation);
        this.getResponse().getFaults().add(result);
        return result;
    }

    public ParameterInfo addRequestParameter(String name, boolean required, String type, ParameterStyle style, String documentation) {
        ParameterInfo result = new ParameterInfo(name, required, type, style, documentation);
        this.getRequest().getParameters().add(result);
        return result;
    }

    public RepresentationInfo addRequestRepresentation(Variant variant) {
        RepresentationInfo result = new RepresentationInfo(variant);
        this.getRequest().getRepresentations().add(result);
        return result;
    }

    public ParameterInfo addResponseParameter(String name, boolean required, String type, ParameterStyle style, String documentation) {
        ParameterInfo result = new ParameterInfo(name, required, type, style, documentation);
        this.getResponse().getParameters().add(result);
        return result;
    }

    public RepresentationInfo addResponseRepresentation(Variant variant) {
        RepresentationInfo result = new RepresentationInfo(variant);
        this.getResponse().getRepresentations().add(result);
        return result;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Method getName() {
        return this.name;
    }

    public RequestInfo getRequest() {
        return this.request;
    }

    public ResponseInfo getResponse() {
        return this.response;
    }

    public Reference getTargetRef() {
        return this.targetRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setName(Method name) {
        this.name = name;
    }

    public void setRequest(RequestInfo request) {
        this.request = request;
    }

    public void setResponse(ResponseInfo response) {
        this.response = response;
    }

    public void setTargetRef(Reference targetRef) {
        this.targetRef = targetRef;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        if (this.getRequest() != null) {
            this.getRequest().updateNamespaces(namespaces);
        }
        if (this.getResponse() != null) {
            this.getResponse().updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getName() != null && this.getName().toString() != null) {
            attributes.addAttribute("", "name", null, "xs:NMTOKEN", this.getName().toString());
        }
        if (this.getTargetRef() != null && this.getTargetRef().toString() != null) {
            attributes.addAttribute("", "href", null, "xs:anyURI", this.getTargetRef().toString());
        }
        if (this.getDocumentations().isEmpty() && this.getRequest() == null && this.getResponse() == null) {
            writer.emptyElement("http://research.sun.com/wadl/2006/10", "method", null, (Attributes)attributes);
        } else {
            writer.startElement("http://research.sun.com/wadl/2006/10", "method", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            if (this.getRequest() != null) {
                this.getRequest().writeElement(writer);
            }
            if (this.getResponse() != null) {
                this.getResponse().writeElement(writer);
            }
            writer.endElement("http://research.sun.com/wadl/2006/10", "method");
        }
    }
}

