/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Engine;
import org.restlet.util.Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends Connector {
    private String address;
    private int port;
    private Restlet target;
    private Helper helper;

    public Server(Context context, List<Protocol> protocols, int port, Restlet target) {
        this(context, protocols, null, port, target);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet target) {
        super(context, protocols);
        this.address = address;
        this.port = port;
        this.target = target;
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this);
        }
    }

    public Server(Context context, Protocol protocol, int port, Restlet target) {
        this(context, protocol, null, port, target);
    }

    public Server(Context context, Protocol protocol, Restlet target) {
        this(context, protocol, null, protocol.getDefaultPort(), target);
    }

    public Server(Context context, Protocol protocol, String address, int port, Restlet target) {
        this(context, Arrays.asList(protocol), address, port, target);
    }

    public Server(List<Protocol> protocols, int port, Restlet target) {
        this(null, protocols, port, target);
    }

    public Server(List<Protocol> protocols, String address, int port, Restlet target) {
        this(null, protocols, address, port, target);
    }

    public Server(Protocol protocol, int port, Restlet target) {
        this(null, protocol, port, target);
    }

    public Server(Protocol protocol, Restlet target) {
        this(null, protocol, target);
    }

    public Server(Protocol protocol, String address, Restlet target) {
        this(null, protocol, address, protocol.getDefaultPort(), target);
    }

    public Server(Protocol protocol, String address, int port, Restlet target) {
        this(null, protocol, address, port, target);
    }

    public String getAddress() {
        return this.address;
    }

    private Helper getHelper() {
        return this.helper;
    }

    public int getPort() {
        return this.port;
    }

    public Restlet getTarget() {
        return this.target;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getTarget() != null) {
            this.getTarget().handle(request, response);
        }
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    protected void setAddress(String address) {
        this.address = address;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.getHelper() != null) {
            this.getHelper().start();
        }
    }

    @Override
    public void stop() throws Exception {
        this.getHelper().stop();
        if (this.getHelper() != null) {
            super.stop();
        }
    }
}

