/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile Logger logger;
    private final Series<Parameter> parameters;

    public static Context getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Context context) {
        CURRENT.set(context);
    }

    public Context() {
        this("org.restlet");
    }

    public Context(Logger logger) {
        this.logger = logger;
        this.parameters = new Form((List<Parameter>)new CopyOnWriteArrayList<Parameter>());
    }

    public Context(String loggerName) {
        this(Logger.getLogger(loggerName));
    }

    public Context createChildContext() {
        return new Context();
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public Uniform getClientDispatcher() {
        return null;
    }

    @Deprecated
    public Uniform getDispatcher() {
        return this.getClientDispatcher();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Series<Parameter> getParameters() {
        return this.parameters;
    }

    public Uniform getServerDispatcher() {
        return null;
    }

    public synchronized void setAttributes(Map<String, Object> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public synchronized void setParameters(Series<Parameter> parameters) {
        this.parameters.clear();
        this.parameters.addAll(parameters);
    }
}

