/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Map;
import java.util.TreeMap;
import org.restlet.Application;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.SaxRepresentation;
import org.restlet.resource.StringRepresentation;
import org.restlet.service.ConverterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private volatile Map<String, Object> attributes = null;
    private volatile Representation entity;
    private volatile DomRepresentation domRepresentation;
    private volatile Form form;
    private volatile SaxRepresentation saxRepresentation;

    public Message() {
        this(null);
    }

    public Message(Representation entity) {
        this.entity = entity;
        this.domRepresentation = null;
        this.form = null;
        this.saxRepresentation = null;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Object>();
        }
        return this.attributes;
    }

    @Deprecated
    private ConverterService getConverterService() {
        ConverterService result = null;
        Application application = Application.getCurrent();
        result = application != null ? application.getConverterService() : new ConverterService();
        return result;
    }

    public Representation getEntity() {
        return this.entity;
    }

    public DomRepresentation getEntityAsDom() {
        if (this.domRepresentation == null) {
            this.domRepresentation = this.getEntity() == null ? null : new DomRepresentation(this.getEntity());
        }
        return this.domRepresentation;
    }

    public Form getEntityAsForm() {
        if (this.form == null) {
            this.form = new Form(this.getEntity());
        }
        return this.form;
    }

    @Deprecated
    public Object getEntityAsObject() {
        return this.getConverterService().toObject(this.getEntity());
    }

    public SaxRepresentation getEntityAsSax() {
        if (this.saxRepresentation == null) {
            this.saxRepresentation = this.getEntity() == null ? null : new SaxRepresentation(this.getEntity());
        }
        return this.saxRepresentation;
    }

    public boolean isEntityAvailable() {
        return this.getEntity() != null && this.getEntity().getSize() != 0L && this.getEntity().isAvailable();
    }

    public void release() {
        if (this.getEntity() != null) {
            this.getEntity().release();
        }
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Deprecated
    public void setEntity(Object object) {
        if (object instanceof Representation) {
            this.setEntity((Representation)object);
        } else {
            this.setEntity(this.getConverterService().toRepresentation(object));
        }
    }

    public void setEntity(Representation entity) {
        this.entity = entity;
    }

    public void setEntity(String value, MediaType mediaType) {
        this.setEntity(new StringRepresentation((CharSequence)value, mediaType));
    }
}

