/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.example.ext.rdf.foaf.objects.Contact;
import org.restlet.example.ext.rdf.foaf.objects.User;
import org.restlet.example.ext.rdf.foaf.resources.BaseResource;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class UserResource
extends BaseResource {
    private List<Contact> contacts;
    private User user;

    protected void doInit() throws ResourceException {
        String userId = (String)this.getRequestAttributes().get("userId");
        this.user = this.getObjectsFacade().getUserById(userId);
        if (this.user != null) {
            this.contacts = this.user.getContacts();
        } else {
            this.setExisting(false);
        }
    }

    @Delete
    public void removeUser() throws ResourceException {
        this.getObjectsFacade().deleteUser(this.user);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef().getParentRef());
    }

    @Put
    public void storeUser(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        this.user.setFirstName(form.getFirstValue("firstName"));
        this.user.setLastName(form.getFirstValue("lastName"));
        this.user.setImage(form.getFirstValue("image"));
        this.getObjectsFacade().updateUser(this.user);
        this.getResponse().redirectSeeOther(this.getRequest().getResourceRef());
    }

    @Get(value="rdf")
    public Representation toFoaf() throws ResourceException {
        return this.getFoafRepresentation(this.user, this.getRequest().getResourceRef());
    }

    @Get(value="html")
    public Representation toHtml() throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("user", this.user);
        dataModel.put("contacts", this.contacts);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getTemplateRepresentation("user.html", dataModel, MediaType.TEXT_HTML);
    }
}

