/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.internal.memory.AuthenticatedUserImpl;

public class ClientImpl
implements Client {
    private final String clientId;
    private final String clientSecret;
    private final String redirectUri;
    private final Set<AuthenticatedUser> users;
    private final String applicationName;

    public ClientImpl(String clientId, String redirectUri) {
        this(clientId, null, redirectUri, null);
    }

    public ClientImpl(String clientId, String clientSecret, String redirectUri) {
        this(clientId, clientSecret, redirectUri, null);
    }

    public ClientImpl(String clientId, String clientSecret, String redirectUri, String name) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.applicationName = name;
        this.users = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public boolean containsUser(String userId) {
        return this.users.contains(new AuthenticatedUserImpl(userId, this));
    }

    @Override
    public AuthenticatedUser createUser(String id) {
        AuthenticatedUserImpl user = new AuthenticatedUserImpl(id, this);
        this.users.add(user);
        return user;
    }

    @Override
    public AuthenticatedUser findUser(String id) {
        if (id != null && id.length() > 0) {
            for (AuthenticatedUser user : this.users) {
                if (!user.getId().equals(id)) continue;
                return user;
            }
        }
        return null;
    }

    @Override
    public void revokeUser(String id) {
        this.users.remove(new AuthenticatedUserImpl(id, this));
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    public String toString() {
        if (this.applicationName != null && this.applicationName.length() > 0) {
            return "Application = " + this.applicationName + " CB = " + this.redirectUri;
        }
        return "ClientId = " + this.clientId + " CB = " + this.redirectUri;
    }
}

