/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Parameter;
import org.restlet.engine.RestletHelper;
import org.restlet.ext.ssl.DefaultSslContextFactory;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.util.Series;

public class SslUtils {
    private static final ConcurrentMap<String, Integer> keySizesCache = new ConcurrentHashMap<String, Integer>();

    public static Integer extractKeySize(String sslCipherSuite) {
        String encAlgorithm;
        int encAlgorithmIndex;
        Integer keySize = (Integer)keySizesCache.get(sslCipherSuite);
        if (keySize == null && (encAlgorithmIndex = sslCipherSuite.indexOf("WITH_")) >= 0 && (encAlgorithm = sslCipherSuite.substring(encAlgorithmIndex + 5)) != null) {
            if (encAlgorithm.startsWith("NULL_")) {
                keySize = 0;
            } else if (encAlgorithm.startsWith("IDEA_CBC_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("RC2_CBC_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_40_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("RC4_128_")) {
                keySize = 128;
            } else if (encAlgorithm.startsWith("DES40_CBC_")) {
                keySize = 40;
            } else if (encAlgorithm.startsWith("DES_CBC_")) {
                keySize = 56;
            } else if (encAlgorithm.startsWith("3DES_EDE_CBC_")) {
                keySize = 168;
            } else {
                StringTokenizer st = new StringTokenizer(encAlgorithm, "_");
                while (st.hasMoreTokens()) {
                    try {
                        keySize = Integer.valueOf(st.nextToken());
                        break;
                    }
                    catch (NumberFormatException e) {
                    }
                }
            }
            if (keySize != null) {
                keySizesCache.put(sslCipherSuite, keySize);
            }
        }
        return keySize;
    }

    public static SslContextFactory getSslContextFactory(RestletHelper<?> helper) {
        String[] sslContextFactoryNames;
        SslContextFactory result = helper.getContext() == null ? null : helper.getContext().getAttributes().get("sslContextFactory");
        if (result == null && (sslContextFactoryNames = helper.getHelpedParameters().getValuesArray("sslContextFactory")) != null) {
            for (String sslContextFactoryName : sslContextFactoryNames) {
                if (result != null || sslContextFactoryName == null) continue;
                try {
                    Class<SslContextFactory> sslContextFactoryClass = Class.forName(sslContextFactoryName).asSubclass(SslContextFactory.class);
                    result = sslContextFactoryClass.newInstance();
                    result.init((Series<Parameter>)helper.getHelpedParameters());
                }
                catch (ClassNotFoundException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to find SslContextFactory class: " + sslContextFactoryName, e);
                }
                catch (ClassCastException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Class " + sslContextFactoryName + " does not implement SslContextFactory.", e);
                }
                catch (InstantiationException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Could not instantiate class " + sslContextFactoryName + " with default constructor.", e);
                }
                catch (IllegalAccessException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Illegal access when instantiating class " + sslContextFactoryName + ".", e);
                }
            }
        }
        if (result == null) {
            result = new DefaultSslContextFactory();
            result.init((Series<Parameter>)helper.getHelpedParameters());
        }
        return result;
    }

    private SslUtils() {
    }
}

