/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.restlet.ext.ssl.DefaultSslContextFactory;

public class WrapperSslSocketFactory
extends SSLSocketFactory {
    private final DefaultSslContextFactory contextFactory;
    private final SSLSocketFactory wrappedSocketFactory;

    public WrapperSslSocketFactory(DefaultSslContextFactory contextFactory, SSLSocketFactory wrappedSocketFactory) {
        this.wrappedSocketFactory = wrappedSocketFactory;
        this.contextFactory = contextFactory;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket();
        return this.initSslSocket(result);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket(host, port);
        return this.initSslSocket(result);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket(host, port, localAddress, localPort);
        return this.initSslSocket(result);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket(s, host, port, autoClose);
        return this.initSslSocket(result);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket(host, port);
        return this.initSslSocket(result);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocket result = (SSLSocket)this.getWrappedSocketFactory().createSocket(host, port, localAddress, localPort);
        return this.initSslSocket(result);
    }

    public DefaultSslContextFactory getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getWrappedSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getWrappedSocketFactory().getSupportedCipherSuites();
    }

    public SSLSocketFactory getWrappedSocketFactory() {
        return this.wrappedSocketFactory;
    }

    protected SSLSocket initSslSocket(SSLSocket sslSocket) {
        if (this.getContextFactory().isNeedClientAuthentication()) {
            sslSocket.setNeedClientAuth(true);
        } else if (this.getContextFactory().isWantClientAuthentication()) {
            sslSocket.setWantClientAuth(true);
        }
        if (this.getContextFactory().getEnabledCipherSuites() != null || this.getContextFactory().getDisabledCipherSuites() != null) {
            sslSocket.setEnabledCipherSuites(this.getContextFactory().getSelectedCipherSuites(sslSocket.getSupportedCipherSuites()));
        }
        if (this.getContextFactory().getEnabledProtocols() != null || this.getContextFactory().getDisabledProtocols() != null) {
            sslSocket.setEnabledProtocols(this.getContextFactory().getSelectedSslProtocols(sslSocket.getSupportedProtocols()));
        }
        return sslSocket;
    }
}

