/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.engine.Engine;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.ext.servlet.ServerServlet;
import org.restlet.ext.xdb.internal.XdbServletCall;
import org.restlet.ext.xdb.internal.XdbServletWarClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdbServerServlet
extends ServerServlet {
    private static final long serialVersionUID = 1L;
    private volatile transient Connection conn;
    private volatile String localAddress = null;
    private volatile int localPort = -1;
    private volatile boolean remoteDebugging = false;

    public static void closeDbResources(Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException s) {
                s.printStackTrace(System.err);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException s) {
                s.printStackTrace(System.err);
            }
        }
    }

    public static Connection getConnection() throws ServletException {
        Connection conn = null;
        if (System.getProperty("java.vm.name").equals("JServer VM")) {
            try {
                conn = DriverManager.getConnection("jdbc:oracle:kprb:", "default", "default");
            }
            catch (SQLException s) {
                System.err.println("Exception getting SQL Connection: " + s.getLocalizedMessage());
                throw new ServletException("Unable to connect using: jdbc:oracle:kprb:", (Throwable)s);
            }
        }
        try {
            Class targetClass = Engine.loadClass((String)"oracle.jdbc.driver.OracleDriver");
            Driver drv = (Driver)targetClass.newInstance();
            DriverManager.registerDriver(drv);
            conn = DriverManager.getConnection("jdbc:oracle:oci:@" + System.getProperty("db.str", "orcl"), System.getProperty("db.usr", "lucene"), System.getProperty("db.pwd", "lucene"));
        }
        catch (SQLException s) {
            System.err.println("Exception getting SQL Connection: " + s.getLocalizedMessage());
            throw new ServletException("Unable to connect using: jdbc:oracle:oci:@" + System.getProperty("db.str", "orcl") + "[" + System.getProperty("db.usr", "lucene") + ":" + System.getProperty("db.pwd", "lucene") + "]", (Throwable)s);
        }
        catch (ClassNotFoundException cnf) {
            System.err.println("Exception getting oracle.jdbc.driver.OracleDriver class: " + cnf.getLocalizedMessage());
        }
        catch (InstantiationException ie) {
            System.err.println("Exception in Driver.newIntance(): " + ie.getLocalizedMessage());
        }
        catch (IllegalAccessException iae) {
            System.err.println("Exception in Driver.newIntance(): " + iae.getLocalizedMessage());
        }
        return conn;
    }

    protected ServerCall createCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        return new XdbServletCall(server, request, response);
    }

    protected Client createWarClient(Context appCtx, ServletConfig config) {
        return new XdbServletWarClient(appCtx, config, this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CallableStatement preparedstatement;
        block4: {
            preparedstatement = null;
            try {
                if (!this.remoteDebugging) break block4;
                preparedstatement = this.conn.prepareCall("{ call dbms_debug_jdwp.disconnect }");
                preparedstatement.execute();
            }
            catch (SQLException e) {
                try {
                    this.log(e.getLocalizedMessage(), e);
                }
                catch (Throwable throwable) {
                    XdbServerServlet.closeDbResources(preparedstatement, null);
                    throw throwable;
                }
                XdbServerServlet.closeDbResources(preparedstatement, null);
            }
        }
        XdbServerServlet.closeDbResources(preparedstatement, null);
        super.destroy();
    }

    protected String getContextPath(HttpServletRequest request) {
        return "";
    }

    public String getInitParameter(String name, String defaultValue) {
        String result = null;
        result = this.getInitParameter(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected String getLocalAddr(HttpServletRequest request) {
        return this.localAddress;
    }

    protected int getLocalPort(HttpServletRequest request) {
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        CallableStatement preparedstatement = null;
        if (this.conn == null) {
            this.conn = XdbServerServlet.getConnection();
        }
        try {
            int endPoint = 1;
            preparedstatement = this.conn.prepareCall("{ call dbms_xdb.getListenerEndPoint(1,?,?,?) }");
            preparedstatement.registerOutParameter(1, 12);
            preparedstatement.registerOutParameter(2, 4);
            preparedstatement.registerOutParameter(3, 4);
            preparedstatement.execute();
            this.localAddress = preparedstatement.getString(1);
            if (this.localAddress == null) {
                this.localAddress = "127.0.0.1";
            }
            this.localPort = preparedstatement.getInt(2);
            endPoint = preparedstatement.getInt(3);
            this.log("The ServerServlet address = " + this.localAddress);
            this.log("The ServerServlet port = " + this.localPort);
            this.log("The ServerServlet endpoint = " + endPoint);
        }
        catch (SQLException e) {
            try {
                this.log(e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                XdbServerServlet.closeDbResources(preparedstatement, null);
                throw throwable;
            }
            XdbServerServlet.closeDbResources(preparedstatement, null);
        }
        XdbServerServlet.closeDbResources(preparedstatement, null);
        try {
            if (this.remoteDebugging) {
                preparedstatement = this.conn.prepareCall("{ call dbms_debug_jdwp.connect_tcp(?,?) }");
                preparedstatement.setString(1, "localhost");
                preparedstatement.setInt(2, 4000);
                preparedstatement.execute();
            }
        }
        catch (SQLException e) {
            this.log(e.getLocalizedMessage(), e);
        }
        finally {
            XdbServerServlet.closeDbResources(preparedstatement, null);
        }
        try {
            String bootstrapClassName = System.getProperty("java.vm.name").equals("JServer VM") ? "RESTLET:org.restlet.ext.xdb.XdbServerServlet" : "org.restlet.ext.xdb.XdbServerServlet";
            Engine.getInstance().setUserClassLoader(this.loadClass(bootstrapClassName).getClassLoader());
            Application app = this.getApplication();
            if (app != null && app.isStopped()) {
                try {
                    app.start();
                }
                catch (Exception e) {
                    this.log("Error during the starting of the Restlet Application", e);
                }
            }
        }
        catch (AccessControlException ace) {
            this.log("Error loading Restlet Application", ace);
            throw new ServletException("Error loading Restlet application", (Throwable)ace);
        }
        catch (ClassNotFoundException cne) {
            this.log("Error loading Restlet Application", cne);
            throw new ServletException("Error loading Restlet application", (Throwable)cne);
        }
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        Class targetClass;
        int doubleDotPos = className.indexOf(58);
        if (doubleDotPos > 0) {
            String sch = className.substring(0, doubleDotPos).toUpperCase();
            String cName = className.substring(doubleDotPos + 1);
            if (System.getProperty("java.vm.name").equals("JServer VM")) {
                try {
                    Class loaderClass = Engine.loadClass((String)"oracle.aurora.rdbms.DbmsJava");
                    Method meth = loaderClass.getMethod("classForNameAndSchema", String.class, String.class);
                    this.log("Schema: " + sch + " class: " + cName + " loader: " + loaderClass);
                    targetClass = (Class)meth.invoke(null, cName, sch);
                }
                catch (NoSuchMethodException nse) {
                    this.log("Could not instantiate a class using SCHEMA: " + sch + " and class: " + cName, nse);
                    targetClass = Engine.loadClass((String)className);
                }
                catch (IllegalAccessException iae) {
                    this.log("Could not instantiate a class using SCHEMA: " + sch + " and class: " + cName, iae);
                    targetClass = Engine.loadClass((String)className);
                }
                catch (InvocationTargetException ite) {
                    this.log("Could not instantiate a class using SCHEMA: " + sch + " and class: " + cName, ite);
                    targetClass = Engine.loadClass((String)className);
                }
                catch (AccessControlException ace) {
                    this.log("Could not instantiate a class using oracle.aurora.rdbms.DbmsJava " + sch + " and class: " + cName, ace);
                    targetClass = Engine.loadClass((String)className);
                }
            } else {
                targetClass = Engine.loadClass((String)className);
            }
        } else {
            targetClass = Engine.loadClass((String)className);
        }
        return targetClass;
    }
}

