/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.ValueTypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BigNumberTypeHandler<TBigNumber>
implements ValueTypeHandler,
VariableLengthTypeHandler,
QueryableTypeHandler,
IndexableTypeHandler {
    public void defragment(DefragmentContext context) {
        this.skip((ReadBuffer)context);
    }

    public void delete(DeleteContext context) throws Db4oIOException {
        this.skip((ReadBuffer)context);
    }

    public Object read(ReadContext context) {
        return this.unmarshall((ReadBuffer)context);
    }

    public void write(WriteContext context, Object obj) {
        byte[] data = this.toByteArray(obj);
        context.writeInt(data.length);
        context.writeBytes(data);
    }

    public PreparedComparison<Object> prepareComparison(final Context context, Object obj) {
        final TBigNumber value = obj instanceof TransactionContext ? this.bigNumberFrom(((TransactionContext)obj)._object, context) : this.bigNumberFrom(obj, context);
        return new PreparedComparison<Object>(){

            public int compareTo(Object other) {
                if (other == null) {
                    return value == null ? 0 : 1;
                }
                if (value == null) {
                    return -1;
                }
                return BigNumberTypeHandler.this.compare(value, BigNumberTypeHandler.this.bigNumberFrom(other, context));
            }
        };
    }

    public boolean descendsIntoMembers() {
        return false;
    }

    public void defragIndexEntry(DefragmentContextImpl context) {
        context.copyID(false, true);
        context.incrementIntSize();
    }

    public int linkLength() {
        return 8;
    }

    public Object readIndexEntry(Context context, ByteArrayBuffer reader) {
        Slot s = new Slot(reader.readInt(), reader.readInt());
        if (this.isInvalidSlot(s)) {
            return null;
        }
        return s;
    }

    public void writeIndexEntry(Context context, ByteArrayBuffer writer, Object entry) {
        if (entry == null) {
            writer.writeInt(0);
            writer.writeInt(0);
            return;
        }
        if (entry instanceof StatefulBuffer) {
            StatefulBuffer entryAsWriter = (StatefulBuffer)entry;
            writer.writeInt(entryAsWriter.getAddress());
            writer.writeInt(entryAsWriter.length());
            return;
        }
        if (entry instanceof Slot) {
            Slot s = (Slot)entry;
            writer.writeInt(s.address());
            writer.writeInt(s.length());
            return;
        }
        throw new IllegalArgumentException();
    }

    public Object indexEntryToObject(Context context, Object indexEntry) {
        if (indexEntry instanceof Slot) {
            Slot slot = (Slot)indexEntry;
            indexEntry = this.bufferFromSlot(context, slot);
        }
        return this.unmarshall((ReadBuffer)indexEntry);
    }

    public Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = context.readInt();
        int length = context.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return ((StatefulBuffer)context.buffer()).readPayloadWriter(payLoadOffSet, length);
    }

    public Object readIndexEntryFromObjectSlot(MarshallerFamily mf, StatefulBuffer buffer) throws CorruptionException, Db4oIOException {
        int payLoadOffSet = buffer.readInt();
        int length = buffer.readInt();
        if (payLoadOffSet == 0) {
            return null;
        }
        return buffer.readPayloadWriter(payLoadOffSet, length);
    }

    protected abstract TBigNumber fromByteArray(byte[] var1);

    protected abstract byte[] toByteArray(TBigNumber var1);

    protected abstract int compare(TBigNumber var1, TBigNumber var2);

    private ByteArrayBuffer bufferFromSlot(Context context, Slot slot) {
        return context.transaction().container().decryptedBufferByAddress(slot.address(), slot.length());
    }

    private TBigNumber bigNumberFrom(Object obj, Context context) {
        if (obj instanceof Slot) {
            obj = this.bufferFromSlot(context, (Slot)obj);
        }
        if (obj instanceof ReadBuffer) {
            ReadBuffer buffer = (ReadBuffer)obj;
            int offset = buffer.offset();
            buffer.seek(0);
            TBigNumber number = this.unmarshall(buffer);
            buffer.seek(offset);
            return number;
        }
        return (TBigNumber)obj;
    }

    private void skip(ReadBuffer context) {
        int numBytes = context.readInt();
        context.seek(context.offset() + numBytes);
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot.isNull();
    }

    private TBigNumber unmarshall(ReadBuffer buffer) {
        byte[] data = new byte[buffer.readInt()];
        buffer.readBytes(data);
        return this.fromByteArray(data);
    }
}

