/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.self;

import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.self.ClassInfo;
import com.db4o.reflect.self.FieldInfo;
import com.db4o.reflect.self.SelfField;
import com.db4o.reflect.self.SelfReflectionRegistry;

public class SelfClass
implements ReflectClass {
    private static final SelfField[] EMPTY_FIELDS = new SelfField[0];
    private boolean _isAbstract;
    private SelfField[] _fields;
    private Reflector _parentReflector;
    private SelfReflectionRegistry _registry;
    private Class _class;
    private Class _superClass;

    public SelfClass(Reflector parentReflector, SelfReflectionRegistry registry, Class clazz) {
        this._parentReflector = parentReflector;
        this._registry = registry;
        this._class = clazz;
    }

    public Class getJavaClass() {
        return this._class;
    }

    public Reflector reflector() {
        return this._parentReflector;
    }

    public ReflectClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this._parentReflector.forClass(this._registry.componentType(this._class));
    }

    public ReflectField[] getDeclaredFields() {
        this.ensureClassInfoLoaded();
        return this._fields;
    }

    private void ensureClassInfoLoaded() {
        if (this._fields == null) {
            ClassInfo classInfo = this._registry.infoFor(this._class);
            if (classInfo == null) {
                this._fields = EMPTY_FIELDS;
                return;
            }
            this._superClass = classInfo.superClass();
            this._isAbstract = classInfo.isAbstract();
            FieldInfo[] fieldInfo = classInfo.fieldInfo();
            if (fieldInfo == null) {
                this._fields = EMPTY_FIELDS;
                return;
            }
            this._fields = new SelfField[fieldInfo.length];
            for (int idx = 0; idx < fieldInfo.length; ++idx) {
                this._fields[idx] = this.selfFieldFor(fieldInfo[idx]);
            }
        }
    }

    public ReflectField getDeclaredField(String name) {
        this.ensureClassInfoLoaded();
        for (int idx = 0; idx < this._fields.length; ++idx) {
            if (!this._fields[idx].getName().equals(name)) continue;
            return this._fields[idx];
        }
        return null;
    }

    private SelfField selfFieldFor(FieldInfo fieldInfo) {
        return new SelfField(fieldInfo.name(), this._parentReflector.forClass(fieldInfo.type()), this, this._registry);
    }

    public ReflectClass getDelegate() {
        return this;
    }

    public ReflectMethod getMethod(String methodName, ReflectClass[] paramClasses) {
        return null;
    }

    public String getName() {
        return this._class.getName();
    }

    public ReflectClass getSuperclass() {
        this.ensureClassInfoLoaded();
        if (this._superClass == null) {
            return null;
        }
        return this._parentReflector.forClass(this._superClass);
    }

    public boolean isAbstract() {
        this.ensureClassInfoLoaded();
        return this._isAbstract || this.isInterface();
    }

    public boolean isArray() {
        return this._class.isArray();
    }

    public boolean isAssignableFrom(ReflectClass type) {
        if (!(type instanceof SelfClass)) {
            return false;
        }
        return this._class.isAssignableFrom(((SelfClass)type).getJavaClass());
    }

    public boolean isCollection() {
        return this._parentReflector.isCollection((ReflectClass)this);
    }

    public boolean isInstance(Object obj) {
        return this._class.isInstance(obj);
    }

    public boolean isInterface() {
        return this._class.isInterface();
    }

    public boolean isPrimitive() {
        return this._registry.isPrimitive(this._class);
    }

    public Object newInstance() {
        try {
            return this._class.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object nullValue() {
        return null;
    }

    public boolean ensureCanBeInstantiated() {
        return true;
    }
}

