/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.application.StatusInfo;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class StatusInfoHtmlConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_XHTML = new VariantInfo(MediaType.APPLICATION_XHTML);
    private static final VariantInfo VARIANT_TEXT_HTML = new VariantInfo(MediaType.TEXT_HTML);

    @Override
    public List<Class<?>> getObjectClasses(Variant source) {
        List<Class<?>> result = null;
        if (this.isCompatible(source)) {
            result = this.addObjectClass(result, StatusInfo.class);
        }
        return result;
    }

    @Override
    public List<VariantInfo> getVariants(Class<?> source) throws IOException {
        List<VariantInfo> result = null;
        if (source != null && StatusInfo.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_TEXT_HTML);
            result = this.addVariant(result, VARIANT_APPLICATION_XHTML);
        }
        return result;
    }

    protected boolean isCompatible(Variant variant) {
        return variant != null && (VARIANT_TEXT_HTML.isCompatible(variant) || VARIANT_APPLICATION_XHTML.isCompatible(variant));
    }

    @Override
    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof StatusInfo && this.isCompatible(target)) {
            result = 1.0f;
        }
        return result;
    }

    @Override
    public <T> float score(Representation source, Class<T> target, Resource resource) {
        return -1.0f;
    }

    @Override
    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        return null;
    }

    @Override
    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        return null;
    }
}

