/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BeanInfoUtils {
    private static final ConcurrentMap<Class<?>, BeanInfo> cache = new ConcurrentHashMap();

    public static BeanInfo getBeanInfo(Class<?> clazz) {
        BeanInfo result = (BeanInfo)cache.get(clazz);
        if (result == null) {
            Class stopClass = Throwable.class.isAssignableFrom(clazz) ? Throwable.class : Object.class;
            try {
                result = Introspector.getBeanInfo(clazz, stopClass, 3);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Could not get BeanInfo of class " + clazz.getName(), e);
            }
            BeanInfo prev = cache.putIfAbsent(clazz, result);
            if (prev != null) {
                result = prev;
            }
        }
        return result;
    }
}

