/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.component.util.Strings;
import org.richfaces.javascript.ClientScriptService;
import org.richfaces.javascript.ClientSideScript;
import org.richfaces.javascript.LibraryFunction;
import org.richfaces.javascript.LibraryFunctionImplementation;
import org.richfaces.javascript.ScriptNotFoundException;
import org.richfaces.resource.ResourceKey;

public class ClientScriptServiceImpl
implements ClientScriptService {
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String ORG_RICHFACES_CSV = "org.richfaces.csv";
    private static final LibraryFunction NO_SCRIPT = new LibraryFunction(){

        public Iterable<ResourceKey> getResources() {
            return Collections.emptySet();
        }

        public String getName() {
            return null;
        }
    };
    private static final Function<Class<?>, ? extends LibraryFunction> RESOURCE_SCRIPT_FUNCTION = new Function<Class<?>, LibraryFunction>(){

        public LibraryFunction apply(Class<?> arg0) {
            return ClientScriptServiceImpl.getScriptResource(FacesContext.getCurrentInstance(), arg0);
        }
    };
    private static final Function<Class<?>, ? extends LibraryFunction> ANNOTATION_SCRIPT_FUNCTION = new Function<Class<?>, LibraryFunction>(){

        public LibraryFunction apply(Class<?> arg0) {
            return ClientScriptServiceImpl.getScriptFromAnnotation(arg0);
        }
    };
    private final ConcurrentMap<Class<?>, LibraryFunction> resourcesMapping;
    private final ConcurrentMap<Class<?>, LibraryFunction> annotationsMapping;
    private final Map<Class<?>, LibraryFunction> defaultMapping;

    public ClientScriptServiceImpl(Map<Class<?>, LibraryFunction> defaultMapping) {
        this.defaultMapping = defaultMapping;
        this.resourcesMapping = new MapMaker().initialCapacity(10).makeComputingMap(RESOURCE_SCRIPT_FUNCTION);
        this.annotationsMapping = new MapMaker().initialCapacity(10).makeComputingMap(ANNOTATION_SCRIPT_FUNCTION);
    }

    public LibraryFunction getScript(FacesContext facesContext, Class<?> javaClass) throws ScriptNotFoundException {
        if (null == facesContext || null == javaClass) {
            throw new NullPointerException();
        }
        LibraryFunction function = NO_SCRIPT;
        if (NO_SCRIPT == function) {
            function = this.defaultMapping.containsKey(javaClass) ? this.defaultMapping.get(javaClass) : this.getFromComputationMap(this.annotationsMapping, javaClass);
        }
        if (NO_SCRIPT == function) {
            throw new ScriptNotFoundException("No client-side script for class " + javaClass.getName());
        }
        return function;
    }

    private LibraryFunction getFromComputationMap(ConcurrentMap<Class<?>, LibraryFunction> map, Class<?> clazz) {
        try {
            return (LibraryFunction)map.get(clazz);
        }
        catch (ComputationException e) {
            Throwable cause = e.getCause();
            throw new FacesException(cause);
        }
    }

    private static LibraryFunction getScriptFromAnnotation(Class<?> javaClass) {
        if (javaClass.isAnnotationPresent(ClientSideScript.class)) {
            ClientSideScript clientSideScript = javaClass.getAnnotation(ClientSideScript.class);
            ArrayList resources = Lists.newArrayList();
            for (ResourceDependency dependency : clientSideScript.resources()) {
                resources.add(ResourceKey.create((String)dependency.name(), (String)dependency.library()));
            }
            return new LibraryFunctionImplementation(clientSideScript.function(), resources);
        }
        return NO_SCRIPT;
    }

    private static LibraryFunction getScriptResource(FacesContext facesContext, Class<?> javaClass) {
        String resourceName;
        ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
        Resource facesResource = resourceHandler.createResource(resourceName = javaClass.getSimpleName() + ".js", ORG_RICHFACES_CSV, TEXT_JAVASCRIPT);
        if (null != facesResource) {
            String functionName = Strings.firstToLowerCase(javaClass.getSimpleName());
            return new LibraryFunctionImplementation(functionName, resourceName, ORG_RICHFACES_CSV);
        }
        return NO_SCRIPT;
    }
}

