/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Dialog.class)
public class ShadowDialog {
    @RealObject
    private Dialog realDialog;
    private boolean isShowing;
    Context context;
    private int layoutId;
    private int themeId;
    private View inflatedView;
    private boolean hasBeenDismissed;
    protected CharSequence title;
    private DialogInterface.OnCancelListener onCancelListener;
    private Window window;
    private Activity ownerActivity;
    private boolean hasShownBefore;
    private static final ArrayList<Dialog> shownDialogs = new ArrayList();
    private boolean isCancelableOnTouchOutside;

    @Resetter
    public static void reset() {
        ShadowDialog.setLatestDialog(null);
        shownDialogs.clear();
    }

    public static Dialog getLatestDialog() {
        ShadowDialog dialog = ShadowApplication.getInstance().getLatestDialog();
        return dialog == null ? null : dialog.realDialog;
    }

    public static void setLatestDialog(ShadowDialog latestDialog) {
        ShadowApplication shadowApplication = ShadowApplication.getInstance();
        if (shadowApplication != null) {
            shadowApplication.setLatestDialog(latestDialog);
        }
    }

    @Implementation
    public void show() {
        ShadowDialog.setLatestDialog(this);
        shownDialogs.add(this.realDialog);
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).show();
    }

    @Implementation
    public void dismiss() {
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).dismiss();
        this.hasBeenDismissed = true;
    }

    public void clickOn(int viewId) {
        this.realDialog.findViewById(viewId).performClick();
    }

    @Implementation
    public void setCanceledOnTouchOutside(boolean flag) {
        this.isCancelableOnTouchOutside = flag;
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).setCanceledOnTouchOutside(flag);
    }

    public boolean isCancelable() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realDialog, (String)"mCancelable");
    }

    public boolean isCancelableOnTouchOutside() {
        return this.isCancelableOnTouchOutside;
    }

    public DialogInterface.OnCancelListener getOnCancelListener() {
        return this.onCancelListener;
    }

    @Implementation
    public void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        this.onCancelListener = listener;
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).setOnCancelListener(listener);
    }

    public boolean hasBeenDismissed() {
        return this.hasBeenDismissed;
    }

    public CharSequence getTitle() {
        return Shadows.shadowOf(this.realDialog.getWindow()).getTitle();
    }

    public void clickOnText(int textId) {
        String text;
        if (this.inflatedView == null) {
            this.inflatedView = LayoutInflater.from((Context)this.context).inflate(this.layoutId, null);
        }
        if (!this.clickOnText(this.inflatedView, text = this.realDialog.getContext().getResources().getString(textId))) {
            throw new IllegalArgumentException("Text not found: " + text);
        }
    }

    public void clickOnText(String text) {
        if (!this.clickOnText(this.inflatedView, text)) {
            throw new IllegalArgumentException("Text not found: " + text);
        }
    }

    private boolean clickOnText(View view, String text) {
        if (text.equals(Shadows.shadowOf(view).innerText())) {
            view.performClick();
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if (!this.clickOnText(child, text)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Dialog> getShownDialogs() {
        return shownDialogs;
    }

    public void callOnCreate(Bundle bundle) {
        ReflectionHelpers.callInstanceMethod((Object)this.realDialog, (String)"onCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle)});
    }
}

