/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import android.os.Process;
import android.service.notification.StatusBarNotification;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=NotificationManager.class, looseSignatures=true)
public class ShadowNotificationManager {
    private boolean mAreNotificationsEnabled = true;
    private Map<Key, Notification> notifications = new HashMap<Key, Notification>();
    private final Map<String, Object> notificationChannels = new HashMap<String, Object>();
    private final Map<String, Object> notificationChannelGroups = new HashMap<String, Object>();
    private final Map<String, Object> deletedNotificationChannels = new HashMap<String, Object>();

    @Implementation
    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    @Implementation
    public void notify(String tag, int id2, Notification notification) {
        this.notifications.put(new Key(tag, id2), notification);
    }

    @Implementation
    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    @Implementation
    public void cancel(String tag, int id2) {
        Key key = new Key(tag, id2);
        if (this.notifications.containsKey(key)) {
            this.notifications.remove(key);
        }
    }

    @Implementation
    public void cancelAll() {
        this.notifications.clear();
    }

    @Implementation(minSdk=24)
    public boolean areNotificationsEnabled() {
        return this.mAreNotificationsEnabled;
    }

    public void setNotificationsEnabled(boolean areNotificationsEnabled) {
        this.mAreNotificationsEnabled = areNotificationsEnabled;
    }

    @Implementation(minSdk=23)
    public StatusBarNotification[] getActiveNotifications() {
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[this.notifications.size()];
        int i = 0;
        for (Map.Entry<Key, Notification> entry : this.notifications.entrySet()) {
            statusBarNotifications[i++] = new StatusBarNotification(RuntimeEnvironment.application.getPackageName(), null, entry.getKey().id, entry.getKey().tag, Process.myUid(), Process.myPid(), 0, entry.getValue(), Process.myUserHandle(), 0L);
        }
        return statusBarNotifications;
    }

    @Implementation(minSdk=26)
    public Object getNotificationChannel(String channelId) {
        return this.notificationChannels.get(channelId);
    }

    @Implementation(minSdk=26)
    public void createNotificationChannelGroup(Object group) {
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)group, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.notificationChannelGroups.put(id2, group);
    }

    @Implementation(minSdk=26)
    public List<Object> getNotificationChannelGroups() {
        return ImmutableList.copyOf(this.notificationChannelGroups.values());
    }

    @Implementation(minSdk=26)
    public void createNotificationChannel(Object channel) {
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (this.deletedNotificationChannels.containsKey(id2)) {
            this.notificationChannels.put(id2, this.deletedNotificationChannels.remove(id2));
        } else {
            this.notificationChannels.put(id2, channel);
        }
    }

    @Implementation(minSdk=26)
    public List<Object> getNotificationChannels() {
        return ImmutableList.copyOf(this.notificationChannels.values());
    }

    @Implementation(minSdk=26)
    public void deleteNotificationChannel(String channelId) {
        if (this.getNotificationChannel(channelId) != null) {
            Object channel = this.notificationChannels.remove(channelId);
            this.deletedNotificationChannels.put(channelId, channel);
        }
    }

    public boolean isChannelDeleted(String channelId) {
        return this.deletedNotificationChannels.containsKey(channelId);
    }

    public Object getNotificationChannelGroup(String id2) {
        return this.notificationChannelGroups.get(id2);
    }

    public int size() {
        return this.notifications.size();
    }

    public Notification getNotification(int id2) {
        return this.notifications.get(new Key(null, id2));
    }

    public Notification getNotification(String tag, int id2) {
        return this.notifications.get(new Key(tag, id2));
    }

    public List<Notification> getAllNotifications() {
        return new ArrayList<Notification>(this.notifications.values());
    }

    private static final class Key {
        public final String tag;
        public final int id;

        private Key(String tag, int id2) {
            this.tag = tag;
            this.id = id2;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 37 * hashCode + (this.tag == null ? 0 : this.tag.hashCode());
            hashCode = 37 * hashCode + this.id;
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return (this.tag == null ? other.tag == null : this.tag.equals(other.tag)) && this.id == other.id;
        }
    }
}

