/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=TelephonyManager.class)
public class ShadowTelephonyManager {
    private final Map<PhoneStateListener, Integer> phoneStateRegistrations = new HashMap<PhoneStateListener, Integer>();
    private PhoneStateListener lastListener;
    private int lastEventFlags;
    private String deviceId;
    private String groupIdLevel1;
    private String networkOperatorName;
    private String networkCountryIso;
    private String networkOperator;
    private String simOperator;
    private String simOperatorName;
    private boolean readPhoneStatePermission = true;
    private int phoneType = 1;
    private String simCountryIso;
    private int simState = 5;
    private String line1Number;
    private int networkType;
    private List<CellInfo> allCellInfo = Collections.emptyList();
    private CellLocation cellLocation = null;
    private int callState = 0;
    private String incomingPhoneNumber = null;

    @Implementation
    public void listen(PhoneStateListener listener, int flags) {
        this.lastListener = listener;
        this.lastEventFlags = flags;
        if (flags == 0) {
            this.phoneStateRegistrations.remove(listener);
        } else {
            this.initListener(listener, flags);
            this.phoneStateRegistrations.put(listener, flags);
        }
    }

    @Deprecated
    public PhoneStateListener getListener() {
        return this.lastListener;
    }

    @Deprecated
    public int getEventFlags() {
        return this.lastEventFlags;
    }

    @Implementation
    public int getCallState() {
        return this.callState;
    }

    public void setCallState(int callState, String incomingPhoneNumber) {
        if (callState != 1) {
            incomingPhoneNumber = null;
        }
        this.callState = callState;
        this.incomingPhoneNumber = incomingPhoneNumber;
        for (PhoneStateListener listener : this.getListenersForFlags(32)) {
            listener.onCallStateChanged(callState, incomingPhoneNumber);
        }
    }

    @Implementation
    public String getDeviceId() {
        this.checkReadPhoneStatePermission();
        return this.deviceId;
    }

    public void setDeviceId(String newDeviceId) {
        this.deviceId = newDeviceId;
    }

    public void setNetworkOperatorName(String networkOperatorName) {
        this.networkOperatorName = networkOperatorName;
    }

    @Implementation
    public String getNetworkOperatorName() {
        return this.networkOperatorName;
    }

    public void setNetworkCountryIso(String networkCountryIso) {
        this.networkCountryIso = networkCountryIso;
    }

    @Implementation
    public String getNetworkCountryIso() {
        return this.networkCountryIso;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    @Implementation
    public String getNetworkOperator() {
        return this.networkOperator;
    }

    @Implementation
    public String getSimOperator() {
        return this.simOperator;
    }

    public void setSimOperator(String simOperator) {
        this.simOperator = simOperator;
    }

    @Implementation
    public String getSimOperatorName() {
        return this.simOperatorName;
    }

    public void setSimOperatorName(String simOperatorName) {
        this.simOperatorName = simOperatorName;
    }

    @Implementation
    public String getSimCountryIso() {
        return this.simCountryIso;
    }

    public void setSimCountryIso(String simCountryIso) {
        this.simCountryIso = simCountryIso;
    }

    @Implementation
    public int getSimState() {
        return this.simState;
    }

    public void setSimState(int simState) {
        this.simState = simState;
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        this.readPhoneStatePermission = readPhoneStatePermission;
    }

    private void checkReadPhoneStatePermission() {
        if (!this.readPhoneStatePermission) {
            throw new SecurityException();
        }
    }

    @Implementation
    public int getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(int phoneType) {
        this.phoneType = phoneType;
    }

    @Implementation
    public String getLine1Number() {
        return this.line1Number;
    }

    public void setLine1Number(String line1Number) {
        this.line1Number = line1Number;
    }

    @Implementation
    public int getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(int networkType) {
        this.networkType = networkType;
    }

    @Implementation(minSdk=17)
    public List<CellInfo> getAllCellInfo() {
        return this.allCellInfo;
    }

    public void setAllCellInfo(List<CellInfo> allCellInfo) {
        this.allCellInfo = allCellInfo;
        if (Build.VERSION.SDK_INT >= 17) {
            for (PhoneStateListener listener : this.getListenersForFlags(1024)) {
                listener.onCellInfoChanged(allCellInfo);
            }
        }
    }

    @Implementation
    public CellLocation getCellLocation() {
        return this.cellLocation;
    }

    public void setCellLocation(CellLocation cellLocation) {
        this.cellLocation = cellLocation;
        for (PhoneStateListener listener : this.getListenersForFlags(16)) {
            listener.onCellLocationChanged(cellLocation);
        }
    }

    @Implementation(minSdk=18)
    public String getGroupIdLevel1() {
        return this.groupIdLevel1;
    }

    public void setGroupIdLevel1(String groupIdLevel1) {
        this.groupIdLevel1 = groupIdLevel1;
    }

    private void initListener(PhoneStateListener listener, int flags) {
        if ((flags & 0x20) != 0) {
            listener.onCallStateChanged(this.callState, this.incomingPhoneNumber);
        }
        if ((flags & 0x400) != 0 && Build.VERSION.SDK_INT >= 17) {
            listener.onCellInfoChanged(this.allCellInfo);
        }
        if ((flags & 0x10) != 0) {
            listener.onCellLocationChanged(this.cellLocation);
        }
    }

    private Iterable<PhoneStateListener> getListenersForFlags(final int flags) {
        return Iterables.filter(this.phoneStateRegistrations.keySet(), (Predicate)new Predicate<PhoneStateListener>(){

            public boolean apply(PhoneStateListener input) {
                return ((Integer)ShadowTelephonyManager.this.phoneStateRegistrations.get(input) & flags) != 0;
            }
        });
    }
}

