/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=Toast.class)
public class ShadowToast {
    private String text;
    private int duration;
    private int gravity;
    private int xOffset;
    private int yOffset;
    private View view;
    @RealObject
    Toast toast;

    public void __constructor__(Context context) {
    }

    @Implementation
    public static Toast makeText(Context context, int resId, int duration) {
        return ShadowToast.makeText(context, context.getResources().getString(resId), duration);
    }

    @Implementation
    public static Toast makeText(Context context, CharSequence text, int duration) {
        Toast toast = new Toast(context);
        toast.setDuration(duration);
        Shadows.shadowOf((Toast)toast).text = text.toString();
        return toast;
    }

    @Implementation
    public void show() {
        Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts().add(this.toast);
    }

    @Implementation
    public void setText(int resId) {
        this.text = RuntimeEnvironment.application.getString(resId);
    }

    @Implementation
    public void setText(CharSequence text) {
        this.text = text.toString();
    }

    @Implementation
    public void setView(View view) {
        this.view = view;
    }

    @Implementation
    public View getView() {
        return this.view;
    }

    @Implementation
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.gravity = gravity;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    @Implementation
    public int getGravity() {
        return this.gravity;
    }

    @Implementation
    public int getXOffset() {
        return this.xOffset;
    }

    @Implementation
    public int getYOffset() {
        return this.yOffset;
    }

    @Implementation
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Implementation
    public int getDuration() {
        return this.duration;
    }

    @Implementation
    public void cancel() {
    }

    public static void reset() {
        Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts().clear();
    }

    public static int shownToastCount() {
        return Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts().size();
    }

    public static boolean showedCustomToast(CharSequence message, int layoutResourceIdToCheckForMessage) {
        for (Toast toast : Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts()) {
            String text = ((TextView)toast.getView().findViewById(layoutResourceIdToCheckForMessage)).getText().toString();
            if (!text.equals(message.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean showedToast(CharSequence message) {
        for (Toast toast : Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts()) {
            String text = Shadows.shadowOf((Toast)toast).text;
            if (text == null || !text.equals(message.toString())) continue;
            return true;
        }
        return false;
    }

    public static String getTextOfLatestToast() {
        List<Toast> shownToasts = Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts();
        return shownToasts.size() == 0 ? null : Shadows.shadowOf((Toast)shownToasts.get((int)(shownToasts.size() - 1))).text;
    }

    public static Toast getLatestToast() {
        List<Toast> shownToasts = Shadows.shadowOf(RuntimeEnvironment.application).getShownToasts();
        return shownToasts.size() == 0 ? null : shownToasts.get(shownToasts.size() - 1);
    }
}

