/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WifiManager.class)
public class ShadowWifiManager {
    private static float sSignalLevelInPercent = 1.0f;
    private boolean accessWifiStatePermission = true;
    private boolean wifiEnabled = true;
    private boolean wasSaved = false;
    private WifiInfo wifiInfo;
    private List<ScanResult> scanResults;
    private final Map<Integer, WifiConfiguration> networkIdToConfiguredNetworks = new LinkedHashMap<Integer, WifiConfiguration>();
    private Pair<Integer, Boolean> lastEnabledNetwork;
    private DhcpInfo dhcpInfo;
    private boolean isScanAlwaysAvailable = true;

    @Implementation
    public boolean setWifiEnabled(boolean wifiEnabled) {
        this.checkAccessWifiStatePermission();
        this.wifiEnabled = wifiEnabled;
        return true;
    }

    @Implementation
    public boolean isWifiEnabled() {
        this.checkAccessWifiStatePermission();
        return this.wifiEnabled;
    }

    @Implementation
    public int getWifiState() {
        if (this.isWifiEnabled()) {
            return 3;
        }
        return 1;
    }

    @Implementation
    public WifiInfo getConnectionInfo() {
        this.checkAccessWifiStatePermission();
        if (this.wifiInfo == null) {
            this.wifiInfo = (WifiInfo)ReflectionHelpers.callConstructor(WifiInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        return this.wifiInfo;
    }

    @Implementation
    public List<ScanResult> getScanResults() {
        return this.scanResults;
    }

    @Implementation
    public List<WifiConfiguration> getConfiguredNetworks() {
        ArrayList<WifiConfiguration> wifiConfigurations = new ArrayList<WifiConfiguration>();
        for (WifiConfiguration wifiConfiguration : this.networkIdToConfiguredNetworks.values()) {
            wifiConfigurations.add(wifiConfiguration);
        }
        return wifiConfigurations;
    }

    @Implementation(minSdk=21)
    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        return this.getConfiguredNetworks();
    }

    @Implementation
    public int addNetwork(WifiConfiguration config) {
        int networkId = this.networkIdToConfiguredNetworks.size();
        config.networkId = -1;
        this.networkIdToConfiguredNetworks.put(networkId, this.makeCopy(config, networkId));
        return networkId;
    }

    @Implementation
    public boolean removeNetwork(int netId) {
        this.networkIdToConfiguredNetworks.remove(netId);
        return true;
    }

    @Implementation
    public int updateNetwork(WifiConfiguration config) {
        if (config == null || config.networkId < 0) {
            return -1;
        }
        this.networkIdToConfiguredNetworks.put(config.networkId, this.makeCopy(config, config.networkId));
        return config.networkId;
    }

    @Implementation
    public boolean saveConfiguration() {
        this.wasSaved = true;
        return true;
    }

    @Implementation
    public boolean enableNetwork(int netId, boolean disableOthers) {
        this.lastEnabledNetwork = new Pair((Object)netId, (Object)disableOthers);
        return true;
    }

    @Implementation
    public WifiManager.WifiLock createWifiLock(int lockType, String tag) {
        return (WifiManager.WifiLock)ReflectionHelpers.callConstructor(WifiManager.WifiLock.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    public WifiManager.WifiLock createWifiLock(String tag) {
        return this.createWifiLock(1, tag);
    }

    @Implementation
    public static int calculateSignalLevel(int rssi, int numLevels) {
        return (int)(sSignalLevelInPercent * (float)(numLevels - 1));
    }

    @Implementation
    public boolean startScan() {
        return true;
    }

    @Implementation
    public DhcpInfo getDhcpInfo() {
        return this.dhcpInfo;
    }

    @Implementation(minSdk=18)
    public boolean isScanAlwaysAvailable() {
        return this.isScanAlwaysAvailable;
    }

    public static void setSignalLevelInPercent(float level) {
        if (level < 0.0f || level > 1.0f) {
            throw new IllegalArgumentException("level needs to be between 0 and 1");
        }
        sSignalLevelInPercent = level;
    }

    public void setAccessWifiStatePermission(boolean accessWifiStatePermission) {
        this.accessWifiStatePermission = accessWifiStatePermission;
    }

    public void setScanResults(List<ScanResult> scanResults) {
        this.scanResults = scanResults;
    }

    public void setDhcpInfo(DhcpInfo dhcpInfo) {
        this.dhcpInfo = dhcpInfo;
    }

    public Pair<Integer, Boolean> getLastEnabledNetwork() {
        return this.lastEnabledNetwork;
    }

    public boolean wasConfigurationSaved() {
        return this.wasSaved;
    }

    public void setIsScanAlwaysAvailable(boolean isScanAlwaysAvailable) {
        this.isScanAlwaysAvailable = isScanAlwaysAvailable;
    }

    private void checkAccessWifiStatePermission() {
        if (!this.accessWifiStatePermission) {
            throw new SecurityException();
        }
    }

    private WifiConfiguration makeCopy(WifiConfiguration config, int networkId) {
        WifiConfiguration copy = Shadows.shadowOf(config).copy();
        copy.networkId = networkId;
        return copy;
    }

    @Implements(value=WifiManager.WifiLock.class)
    public static class ShadowWifiLock {
        private int refCount;
        private boolean refCounted = true;
        private boolean locked;
        public static final int MAX_ACTIVE_LOCKS = 50;

        @Implementation
        public synchronized void acquire() {
            if (this.refCounted) {
                if (++this.refCount >= 50) {
                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                }
            } else {
                this.locked = true;
            }
        }

        @Implementation
        public synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WifiLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        public synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }

        @Implementation
        public void setReferenceCounted(boolean refCounted) {
            this.refCounted = refCounted;
        }
    }
}

