/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.List;

public class AttrData {
    private final String name;
    private final String format;
    private final List<Pair> pairs;

    public AttrData(String name, String format, List<Pair> pairs) {
        this.name = name;
        this.format = format;
        this.pairs = pairs;
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getValueFor(String key) {
        if (this.pairs == null) {
            return null;
        }
        for (Pair pair : this.pairs) {
            if (!pair.name.equals(key)) continue;
            return pair.value;
        }
        return null;
    }

    public boolean isValue(String value) {
        if (this.pairs == null) {
            return false;
        }
        for (Pair pair : this.pairs) {
            if (!pair.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AttrData{name='").append(this.name).append("', format='").append(this.format).append('\'');
        if (this.pairs != null) {
            for (Pair p : this.pairs) {
                builder.append(' ').append(p.name).append("='").append(p.value).append('\'');
            }
        }
        builder.append('}');
        return builder.toString();
    }

    public static class Pair {
        private final String name;
        private final String value;

        public Pair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

