/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.List;
import javax.annotation.Nonnull;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceRemapper;
import org.robolectric.res.ResourceTableFactory;

public class ResourceMerger {
    @Nonnull
    public PackageResourceTable buildResourceTable(AndroidManifest appManifest) {
        ResourceRemapper resourceRemapper = new ResourceRemapper(appManifest.getRClass());
        ResourcePath appResourcePath = appManifest.getResourcePath();
        List<ResourcePath> allResourcePaths = appManifest.getIncludedResourcePaths();
        for (ResourcePath resourcePath : allResourcePaths) {
            if (resourcePath.equals(appResourcePath) || resourcePath.getRClass() == null) continue;
            resourceRemapper.remapRClass(resourcePath.getRClass());
        }
        return new ResourceTableFactory().newResourceTable(appManifest.getPackageName(), allResourcePaths.toArray(new ResourcePath[allResourcePaths.size()]));
    }
}

