/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.IOException;
import java.nio.file.Path;
import org.robolectric.res.DirBaseNameFilter;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;

public class RawResourceLoader {
    private final ResourcePath resourcePath;

    public RawResourceLoader(ResourcePath resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void loadTo(PackageResourceTable resourceTable) throws IOException {
        this.load(resourceTable, "raw");
        this.load(resourceTable, "drawable");
    }

    public void load(PackageResourceTable resourceTable, String folderBaseName) throws IOException {
        Path resourceBase = this.resourcePath.getResourceBase();
        for (Path dir : Fs.listFiles(resourceBase, new DirBaseNameFilter(folderBaseName))) {
            this.loadRawFiles(resourceTable, folderBaseName, dir);
        }
    }

    private void loadRawFiles(PackageResourceTable resourceTable, String resourceType, Path rawDir) throws IOException {
        Qualifiers qualifiers;
        try {
            qualifiers = Qualifiers.fromParentDir(rawDir);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(rawDir);
            String string2 = e.getMessage();
            Logger.warn((String)new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString(), (Object[])new Object[0]);
            return;
        }
        for (Path file : Fs.listFiles(rawDir)) {
            String fileBaseName = Fs.baseNameFor(file);
            resourceTable.addResource(resourceType, fileBaseName, new FileTypedResource(file, ResType.FILE, new XmlContext(resourceTable.getPackageName(), file, qualifiers)));
        }
    }
}

