/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.MetaData;

public class ActivityData {
    private static final String ALLOW_TASK_REPARENTING = "allowTaskReparenting";
    private static final String ALWAYS_RETAIN_TASK_STATE = "alwaysRetainTaskState";
    private static final String CLEAR_TASK_ON_LAUNCH = "clearTaskOnLaunch";
    private static final String CONFIG_CHANGES = "configChanges";
    private static final String ENABLED = "enabled";
    private static final String EXCLUDE_FROM_RECENTS = "excludeFromRecents";
    private static final String EXPORTED = "exported";
    private static final String FINISH_ON_TASK_LAUNCH = "finishOnTaskLaunch";
    private static final String HARDWARE_ACCELERATED = "hardwareAccelerated";
    private static final String ICON = "icon";
    private static final String LABEL = "label";
    private static final String LAUNCH_MODE = "launchMode";
    private static final String MULTIPROCESS = "multiprocess";
    private static final String NAME = "name";
    private static final String NO_HISTORY = "noHistory";
    private static final String PARENT_ACTIVITY_NAME = "parentActivityName";
    private static final String PERMISSION = "permission";
    private static final String PROCESS = "process";
    private static final String SCREEN_ORIENTATION = "screenOrientation";
    private static final String STATE_NOT_NEEDED = "stateNotNeeded";
    private static final String TARGET_ACTIVITY = "targetActivity";
    private static final String TASK_AFFINITY = "taskAffinity";
    private static final String THEME = "theme";
    private static final String UI_OPTIONS = "uiOptions";
    private static final String WINDOW_SOFT_INPUT_MODE = "windowSoftInputMode";
    private final List<IntentFilterData> intentFilters;
    private final HashMap<String, String> attrs;
    private final ActivityData targetActivity;
    private final String xmlns;
    private final MetaData metaData;

    public ActivityData(Map<String, String> attrMap, List<IntentFilterData> intentFilters) {
        this("android", attrMap, intentFilters);
    }

    public ActivityData(String xmlns, Map<String, String> attrMap, List<IntentFilterData> intentFilters) {
        this(xmlns, attrMap, intentFilters, null, null);
    }

    public ActivityData(String xmlns, Map<String, String> attrMap, List<IntentFilterData> intentFilters, ActivityData targetActivity, MetaData metaData) {
        this.xmlns = xmlns;
        this.attrs = new HashMap();
        this.attrs.putAll(attrMap);
        this.intentFilters = new ArrayList<IntentFilterData>(intentFilters);
        this.targetActivity = targetActivity;
        this.metaData = metaData;
    }

    public boolean isAllowTaskReparenting() {
        return this.getBooleanAttr(this.withXMLNS(ALLOW_TASK_REPARENTING), false);
    }

    public boolean isAlwaysRetainTaskState() {
        return this.getBooleanAttr(this.withXMLNS(ALWAYS_RETAIN_TASK_STATE), false);
    }

    public boolean isClearTaskOnLaungh() {
        return this.getBooleanAttr(this.withXMLNS(CLEAR_TASK_ON_LAUNCH), false);
    }

    public int getConfigChanges() {
        String v = this.attrs.get(this.withXMLNS(CONFIG_CHANGES));
        String[] options = new String[]{"mcc", "mnc", "locale", "touchscreen", "keyboard", "keyboardHidden", "navigation", "screenLayout", "fontScale", "uiMode", "orientation", "screenSize", "smallestScreenSize"};
        int[] flags = new int[]{1, 2, 4, 8, 16, 32, 64, 256, 0x40000000, 512, 128, 1024, 2048};
        return this.decodeOptions(v, options, flags);
    }

    public boolean isEnabled() {
        return this.getBooleanAttr(this.withXMLNS(ENABLED), true);
    }

    public boolean isExcludedFromRecents() {
        return this.getBooleanAttr(this.withXMLNS(EXCLUDE_FROM_RECENTS), false);
    }

    public boolean isExported() {
        boolean defaultValue = false;
        return this.getBooleanAttr(this.withXMLNS(EXPORTED), defaultValue);
    }

    public boolean isFinishOnTaskLaunch() {
        return this.getBooleanAttr(this.withXMLNS(FINISH_ON_TASK_LAUNCH), false);
    }

    public boolean isHardwareAccelerated() {
        return this.getBooleanAttr(this.withXMLNS(HARDWARE_ACCELERATED), false);
    }

    public String getLabel() {
        return this.attrs.get(this.withXMLNS(LABEL));
    }

    public String getLaunchMode() {
        return this.attrs.get(this.withXMLNS(LAUNCH_MODE));
    }

    public boolean isMultiprocess() {
        return this.getBooleanAttr(this.withXMLNS(MULTIPROCESS), false);
    }

    public String getName() {
        return this.attrs.get(this.withXMLNS(NAME));
    }

    public boolean isNoHistory() {
        return this.getBooleanAttr(this.withXMLNS(NO_HISTORY), false);
    }

    public String getParentActivityName() {
        return this.attrs.get(this.withXMLNS(PARENT_ACTIVITY_NAME));
    }

    public String getPermission() {
        return this.attrs.get(this.withXMLNS(PERMISSION));
    }

    public String getProcess() {
        return this.attrs.get(this.withXMLNS(PROCESS));
    }

    public String getScreenOrientation() {
        return this.attrs.get(this.withXMLNS(SCREEN_ORIENTATION));
    }

    public boolean isStateNotNeeded() {
        return this.getBooleanAttr(this.withXMLNS(STATE_NOT_NEEDED), false);
    }

    public String getTargetActivityName() {
        return this.attrs.get(this.withXMLNS(TARGET_ACTIVITY));
    }

    public String getTaskAffinity() {
        return this.attrs.get(this.withXMLNS(TASK_AFFINITY));
    }

    public String getThemeRef() {
        return this.attrs.get(this.withXMLNS(THEME));
    }

    public String getUIOptions() {
        return this.attrs.get(this.withXMLNS(UI_OPTIONS));
    }

    public String getWindowSoftInputMode() {
        return this.attrs.get(this.withXMLNS(WINDOW_SOFT_INPUT_MODE));
    }

    private boolean getBooleanAttr(String n, boolean defaultValue) {
        return this.attrs.containsKey(n) ? Boolean.parseBoolean(this.attrs.get(n)) : defaultValue;
    }

    private String withXMLNS(String attr) {
        return ActivityData.withXMLNS(this.xmlns, attr);
    }

    private int decodeOptions(String v, String[] possibleFlags, int[] flagValues) {
        String[] pieces;
        int res = 0;
        if (v == null || "".equals(v)) {
            return res;
        }
        block0: for (String s : pieces = v.split("\\|")) {
            s = s.trim();
            for (int i = 0; i < possibleFlags.length; ++i) {
                if (!s.equals(possibleFlags[i])) continue;
                res |= flagValues[i];
                continue block0;
            }
        }
        return res;
    }

    public Map<String, String> getAllAttributes() {
        return this.attrs;
    }

    public List<IntentFilterData> getIntentFilters() {
        return this.intentFilters;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ActivityData getTargetActivity() {
        return this.targetActivity;
    }

    private static String withXMLNS(String xmlns, String attr) {
        return String.format("%s:%s", xmlns, attr);
    }

    public static String getNameAttr(String xmlns) {
        return ActivityData.withXMLNS(xmlns, NAME);
    }

    public static String getTargetAttr(String xmlns) {
        return ActivityData.withXMLNS("android", TARGET_ACTIVITY);
    }
}

