/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.DrawableNode;
import org.robolectric.res.OverlayResourceIndex;
import org.robolectric.res.PackageResourceLoader;
import org.robolectric.res.Plural;
import org.robolectric.res.PreferenceNode;
import org.robolectric.res.ResName;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XResourceLoader;
import org.robolectric.res.builder.XmlBlock;

public class OverlayResourceLoader
extends XResourceLoader {
    private final String packageName;
    private final List<PackageResourceLoader> subResourceLoaders;

    public OverlayResourceLoader(String packageName, List<PackageResourceLoader> subResourceLoaders) {
        super(new OverlayResourceIndex(packageName, subResourceLoaders));
        this.packageName = packageName;
        this.subResourceLoaders = subResourceLoaders;
    }

    @Override
    void doInitialize() {
        for (PackageResourceLoader subResourceLoader : this.subResourceLoaders) {
            subResourceLoader.initialize();
            this.pluralsData.mergeLibraryStyle(subResourceLoader.pluralsData, this.packageName);
            this.stringData.mergeLibraryStyle(subResourceLoader.stringData, this.packageName);
            this.drawableData.mergeLibraryStyle(subResourceLoader.drawableData, this.packageName);
            this.preferenceData.mergeLibraryStyle(subResourceLoader.preferenceData, this.packageName);
            this.xmlDocuments.mergeLibraryStyle(subResourceLoader.xmlDocuments, this.packageName);
            this.rawResources.mergeLibraryStyle(subResourceLoader.rawResources, this.packageName);
            this.data.mergeLibraryStyle(subResourceLoader.data, this.packageName);
        }
    }

    @Override
    public DrawableNode getDrawableNode(ResName resName, String qualifiers) {
        return super.getDrawableNode(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public Plural getPlural(ResName resName, int quantity, String qualifiers) {
        return super.getPlural(resName.withPackageName(this.packageName), quantity, qualifiers);
    }

    @Override
    public PreferenceNode getPreferenceNode(ResName resName, String qualifiers) {
        return super.getPreferenceNode(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public InputStream getRawValue(ResName resName) {
        return super.getRawValue(resName.withPackageName(this.packageName));
    }

    @Override
    public TypedResource getValue(@NotNull ResName resName, String qualifiers) {
        return super.getValue(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public XmlBlock getXml(ResName resName, String qualifiers) {
        return super.getXml(resName.withPackageName(this.packageName), qualifiers);
    }

    @Override
    public boolean providesFor(String namespace) {
        for (PackageResourceLoader subResourceLoader : this.subResourceLoaders) {
            if (!subResourceLoader.providesFor(namespace)) continue;
            return true;
        }
        return false;
    }
}

