/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.FileFsFile;
import org.robolectric.res.ResourceIndex;

public class ResName {
    private static final Pattern FQN_PATTERN = Pattern.compile("^([^:]*):([^/]+)/(.+)$");
    private static final int NAMESPACE = 1;
    private static final int TYPE = 2;
    private static final int NAME = 3;
    @NotNull
    public final String packageName;
    @NotNull
    public final String type;
    @NotNull
    public final String name;

    public ResName(@NotNull String packageName, @NotNull String type, @NotNull String name) {
        this.packageName = packageName;
        this.type = type;
        this.name = name.indexOf(46) != -1 ? name.replace('.', '_').trim() : name.trim();
    }

    public ResName(@NotNull String fullyQualifiedName) {
        Matcher matcher = FQN_PATTERN.matcher(fullyQualifiedName.trim());
        if (!matcher.find()) {
            throw new IllegalStateException("\"" + fullyQualifiedName + "\" is not fully qualified");
        }
        this.packageName = matcher.group(1);
        this.type = matcher.group(2);
        String nameStr = matcher.group(3);
        String string = this.name = nameStr.indexOf(46) != -1 ? nameStr.replace('.', '_') : nameStr;
        if (this.packageName.equals("xmlns")) {
            throw new IllegalStateException("\"" + fullyQualifiedName + "\" unexpected");
        }
    }

    @NotNull
    public static String qualifyResourceName(@NotNull String possiblyQualifiedResourceName, String defaultPackageName, String defaultType) {
        ResName resName = ResName.qualifyResName(possiblyQualifiedResourceName, defaultPackageName, defaultType);
        return resName.getFullyQualifiedName();
    }

    @NotNull
    public static ResName qualifyResName(@NotNull String possiblyQualifiedResourceName, ResName defaults) {
        return ResName.qualifyResName(possiblyQualifiedResourceName, defaults.packageName, defaults.type);
    }

    @NotNull
    public static ResName qualifyResName(@NotNull String possiblyQualifiedResourceName, String defaultPackageName, String defaultType) {
        int indexOfColon = possiblyQualifiedResourceName.indexOf(58);
        int indexOfSlash = possiblyQualifiedResourceName.indexOf(47);
        String type = null;
        String packageName = null;
        String name = possiblyQualifiedResourceName;
        if (indexOfColon > indexOfSlash) {
            if (indexOfSlash > 0) {
                type = possiblyQualifiedResourceName.substring(0, indexOfSlash);
            }
            packageName = possiblyQualifiedResourceName.substring(indexOfSlash + 1, indexOfColon);
            name = possiblyQualifiedResourceName.substring(indexOfColon + 1);
        } else if (indexOfSlash > indexOfColon) {
            if (indexOfColon > 0) {
                packageName = possiblyQualifiedResourceName.substring(0, indexOfColon);
            }
            type = possiblyQualifiedResourceName.substring(indexOfColon + 1, indexOfSlash);
            name = possiblyQualifiedResourceName.substring(indexOfSlash + 1);
        }
        return new ResName(packageName == null ? defaultPackageName : packageName, type == null ? defaultType : type, name);
    }

    public static Integer getResourceId(ResourceIndex resourceIndex, String possiblyQualifiedResourceName, String contextPackageName) {
        if (possiblyQualifiedResourceName == null) {
            return null;
        }
        if (possiblyQualifiedResourceName.equals("@null")) {
            return null;
        }
        String fullyQualifiedResourceName = ResName.qualifyResourceName(possiblyQualifiedResourceName, contextPackageName, null);
        fullyQualifiedResourceName = fullyQualifiedResourceName.replaceAll("[@+]", "");
        Integer resourceId = resourceIndex.getResourceId(new ResName(fullyQualifiedResourceName));
        return resourceId;
    }

    public static ResName qualifyFromFilePath(@NotNull String packageName, @NotNull String filePath) {
        FileFsFile filePathFile = new FileFsFile(new File(filePath));
        String type = filePathFile.getParent().getName().split("-")[0];
        String name = filePathFile.getBaseName();
        return new ResName(packageName, type, name);
    }

    public ResName qualify(String string) {
        return new ResName(ResName.qualifyResourceName(string.replace("@", ""), this.packageName, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResName resName = (ResName)o;
        if (!this.packageName.equals(resName.packageName)) {
            return false;
        }
        if (!this.type.equals(resName.type)) {
            return false;
        }
        return this.name.equals(resName.name);
    }

    public int hashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "ResName{" + this.getFullyQualifiedName() + "}";
    }

    public String getFullyQualifiedName() {
        return this.packageName + ":" + this.type + "/" + this.name;
    }

    public String getNamespaceUri() {
        return "http://schemas.android.com/apk/res/" + this.packageName;
    }

    public ResName withPackageName(String packageName) {
        if (packageName.equals(this.packageName)) {
            return this;
        }
        return new ResName(packageName, this.type, this.name);
    }

    public void mustBe(String expectedType) {
        if (!this.type.equals(expectedType)) {
            throw new RuntimeException("expected " + this.getFullyQualifiedName() + " to be a " + expectedType + ", is a " + this.type);
        }
    }
}

