/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassNodeProvider {
    private final Map<String, ClassNode> classNodes = new ConcurrentHashMap<String, ClassNode>();

    protected abstract byte[] getClassBytes(String var1) throws ClassNotFoundException;

    ClassNode getClassNode(String internalClassName) throws ClassNotFoundException {
        ClassNode classNode = this.classNodes.get(internalClassName);
        if (classNode == null) {
            classNode = this.createClassNode(internalClassName);
            this.classNodes.put(internalClassName, classNode);
        }
        return classNode;
    }

    private ClassNode createClassNode(String internalClassName) throws ClassNotFoundException {
        byte[] byteCode = this.getClassBytes(internalClassName);
        ClassReader classReader = new ClassReader(byteCode);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 7);
        return classNode;
    }
}

