/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.OldClassInstrumentor;
import org.robolectric.internal.bytecode.ShadowDecorator;
import org.robolectric.util.Util;

public class JarInstrumentor {
    private final InstrumentationConfiguration instrumentationConfiguration = JarInstrumentor.createInstrumentationConfiguration();
    private final ShadowDecorator shadowDecorator = new ShadowDecorator();
    private final OldClassInstrumentor classInstrumentor = new OldClassInstrumentor(this.shadowDecorator);

    public static void main(String[] args) throws Exception {
        new JarInstrumentor().run(args);
    }

    private void run(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: JarInstrumentor <source jar> <dest jar>");
            System.exit(1);
        }
        this.instrumentJar(new File(args[0]), new File(args[1]));
    }

    private void instrumentJar(File sourceFile, File destFile) throws IOException {
        long startNs = System.nanoTime();
        final JarFile jarFile = new JarFile(sourceFile);
        ClassNodeProvider classNodeProvider = new ClassNodeProvider(this){

            @Override
            protected byte[] getClassBytes(String className) throws ClassNotFoundException {
                return JarInstrumentor.getClassBytes(className, jarFile);
            }
        };
        int nonClassCount = 0;
        int classCount = 0;
        TreeSet<String> failedClasses = new TreeSet<String>();
        try (JarOutputStream jarOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(destFile), 32768));){
            String string = String.valueOf(sourceFile);
            String string2 = String.valueOf(destFile);
            System.out.println(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Instrumenting from ").append(string).append(" to ").append(string2).toString());
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (name.endsWith("/")) {
                    jarOut.putNextEntry(new JarEntry(name));
                    continue;
                }
                if (name.endsWith(".class")) {
                    String className = name.substring(0, name.length() - ".class".length()).replace('/', '.');
                    boolean classIsRenamed = this.isClassRenamed(className);
                    if (classIsRenamed) {
                        String string3 = String.valueOf(className);
                        System.out.println(string3.length() != 0 ? "className = ".concat(string3) : new String("className = "));
                        continue;
                    }
                    try {
                        byte[] classBytes = JarInstrumentor.getClassBytes(className, jarFile);
                        byte[] outBytes = this.classInstrumentor.instrument(classBytes, this.instrumentationConfiguration, classNodeProvider);
                        jarOut.putNextEntry(new JarEntry(name));
                        jarOut.write(outBytes);
                        ++classCount;
                    }
                    catch (Exception e) {
                        failedClasses.add(className);
                        System.err.print(new StringBuilder(23 + String.valueOf(className).length()).append("Failed to instrument ").append(className).append(": ").toString());
                        e.printStackTrace();
                    }
                    continue;
                }
                jarOut.putNextEntry(new JarEntry(name));
                Util.copy((InputStream)jarFile.getInputStream(jarEntry), (OutputStream)jarOut);
                ++nonClassCount;
            }
        }
        long elapsedNs = System.nanoTime() - startNs;
        System.out.println(String.format(Locale.getDefault(), "Wrote %d classes and %d resources in %1.2f seconds", classCount, nonClassCount, (double)elapsedNs / 1.0E9));
        if (!failedClasses.isEmpty()) {
            System.out.println("Failed to instrument:");
        }
        for (String failedClass : failedClasses) {
            String string = String.valueOf(failedClass);
            System.out.println(string.length() != 0 ? "- ".concat(string) : new String("- "));
        }
    }

    private boolean isClassRenamed(String className) {
        String internalName = className.replace('.', '/');
        String remappedName = this.instrumentationConfiguration.mappedTypeName(internalName);
        return !remappedName.equals(internalName);
    }

    private static byte[] getClassBytes(String className, JarFile jarFile) throws ClassNotFoundException {
        String classFilename = String.valueOf(className.replace('.', '/')).concat(".class");
        ZipEntry entry = jarFile.getEntry(classFilename);
        try {
            InputStream inputStream = entry == null ? JarInstrumentor.class.getClassLoader().getResourceAsStream(classFilename) : jarFile.getInputStream(entry);
            if (inputStream == null) {
                String string = String.valueOf(className.replace('/', '.'));
                throw new ClassNotFoundException(string.length() != 0 ? "Couldn't find ".concat(string) : new String("Couldn't find "));
            }
            return Util.readBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            String string = String.valueOf(className.replace('/', '.'));
            throw new ClassNotFoundException(string.length() != 0 ? "Couldn't load ".concat(string) : new String("Couldn't load "), e);
        }
    }

    private static InstrumentationConfiguration createInstrumentationConfiguration() {
        InstrumentationConfiguration.Builder builder = InstrumentationConfiguration.newBuilder().doNotAcquirePackage("java.").doNotAcquirePackage("jdk.internal.").doNotAcquirePackage("sun.").doNotAcquirePackage("org.robolectric.annotation.").doNotAcquirePackage("org.robolectric.internal.").doNotAcquirePackage("org.robolectric.pluginapi.").doNotAcquirePackage("org.robolectric.util.");
        builder.doNotAcquireClass("org.robolectric.TestLifecycle").doNotAcquireClass("org.robolectric.AndroidManifest").doNotAcquireClass("org.robolectric.RobolectricTestRunner").doNotAcquireClass("org.robolectric.RobolectricTestRunner%HelperTestRunner").doNotAcquireClass("org.robolectric.res.ResourcePath").doNotAcquireClass("org.robolectric.res.ResourceTable").doNotAcquireClass("org.robolectric.res.builder.XmlBlock");
        builder.doNotAcquirePackage("javax.").doNotAcquirePackage("org.junit").doNotAcquirePackage("org.hamcrest").doNotAcquirePackage("org.robolectric.annotation.").doNotAcquirePackage("org.robolectric.internal.").doNotAcquirePackage("org.robolectric.pluginapi.").doNotAcquirePackage("org.robolectric.manifest.").doNotAcquirePackage("org.robolectric.res.").doNotAcquirePackage("org.robolectric.util.").doNotAcquirePackage("org.robolectric.RobolectricTestRunner$").doNotAcquirePackage("sun.").doNotAcquirePackage("com.sun.").doNotAcquirePackage("org.w3c.").doNotAcquirePackage("org.xml.").doNotAcquirePackage("org.specs2").doNotAcquirePackage("scala.").doNotAcquirePackage("kotlin.").doNotAcquirePackage("io.mockk.").doNotAcquirePackage("org.bouncycastle.").doNotAcquirePackage("org.conscrypt.").doNotAcquirePackage("com.almworks.sqlite4java").doNotAcquirePackage("org.jacoco.");
        builder.doNotInstrumentClass("android.R").doNotInstrumentClass("android.R$styleable");
        builder.addInstrumentedPackage("dalvik.").addInstrumentedPackage("libcore.").addInstrumentedPackage("android.").addInstrumentedPackage("com.android.internal.").addInstrumentedPackage("org.apache.http.").addInstrumentedPackage("org.ccil.cowan.tagsoup").addInstrumentedPackage("org.kxml2.");
        builder.doNotInstrumentPackage("androidx.test");
        builder.doNotAcquireClass("org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher");
        return builder.build();
    }
}

