/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.SwitchPoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ShadowInvalidator {
    private static final SwitchPoint DUMMY = new SwitchPoint();
    private Map<String, SwitchPoint> switchPoints = new HashMap<String, SwitchPoint>();

    public SwitchPoint getSwitchPoint(Class<?> caller) {
        return this.getSwitchPoint(caller.getName());
    }

    public synchronized SwitchPoint getSwitchPoint(String className) {
        SwitchPoint switchPoint = this.switchPoints.get(className);
        if (switchPoint == null) {
            switchPoint = new SwitchPoint();
            this.switchPoints.put(className, switchPoint);
        }
        return switchPoint;
    }

    public synchronized void invalidateClasses(Collection<String> classNames) {
        if (classNames.isEmpty()) {
            return;
        }
        SwitchPoint[] points = new SwitchPoint[classNames.size()];
        int i = 0;
        for (String className : classNames) {
            SwitchPoint switchPoint = this.switchPoints.put(className, null);
            if (switchPoint == null) {
                switchPoint = DUMMY;
            }
            points[i++] = switchPoint;
        }
        SwitchPoint.invalidateAll(points);
    }

    static {
        SwitchPoint.invalidateAll(new SwitchPoint[]{DUMMY});
    }
}

