/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import java.util.Locale;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;

@Implements(value=Configuration.class)
public class ShadowConfiguration {
    @RealObject
    private Configuration realConfiguration;
    public int screenLayout;
    public int touchscreen;
    public int orientation;
    private String qualifiers = "";

    public void __constructor__(Configuration other) {
        this.realConfiguration.setTo(other);
    }

    @Implementation
    public void setTo(Configuration o) {
        this.realConfiguration.fontScale = o.fontScale;
        this.realConfiguration.mcc = o.mcc;
        this.realConfiguration.mnc = o.mnc;
        if (o.locale != null) {
            this.realConfiguration.locale = (Locale)o.locale.clone();
        }
        this.realConfiguration.touchscreen = o.touchscreen;
        this.realConfiguration.keyboard = o.keyboard;
        this.realConfiguration.keyboardHidden = o.keyboardHidden;
        this.realConfiguration.hardKeyboardHidden = o.hardKeyboardHidden;
        this.realConfiguration.navigation = o.navigation;
        this.realConfiguration.navigationHidden = o.navigationHidden;
        this.realConfiguration.orientation = o.orientation;
        this.realConfiguration.screenLayout = o.screenLayout;
        this.realConfiguration.uiMode = o.uiMode;
        this.realConfiguration.screenWidthDp = o.screenWidthDp;
        this.realConfiguration.screenHeightDp = o.screenHeightDp;
        this.realConfiguration.smallestScreenWidthDp = o.smallestScreenWidthDp;
    }

    @Implementation
    public int compareTo(Configuration that) {
        float a = this.realConfiguration.fontScale;
        float b = that.fontScale;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int n = this.realConfiguration.mcc - that.mcc;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.mnc - that.mnc;
        if (n != 0) {
            return n;
        }
        if (this.realConfiguration.locale == null) {
            if (that.locale != null) {
                return 1;
            }
        } else {
            if (that.locale == null) {
                return -1;
            }
            n = this.realConfiguration.locale.getLanguage().compareTo(that.locale.getLanguage());
            if (n != 0) {
                return n;
            }
            n = this.realConfiguration.locale.getCountry().compareTo(that.locale.getCountry());
            if (n != 0) {
                return n;
            }
            n = this.realConfiguration.locale.getVariant().compareTo(that.locale.getVariant());
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.realConfiguration.touchscreen - that.touchscreen) != 0) {
            return n;
        }
        n = this.realConfiguration.keyboard - that.keyboard;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.keyboardHidden - that.keyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.hardKeyboardHidden - that.hardKeyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.navigation - that.navigation;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.navigationHidden - that.navigationHidden;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.orientation - that.orientation;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.screenLayout - that.screenLayout;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.uiMode - that.uiMode;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.screenWidthDp - that.screenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.screenHeightDp - that.screenHeightDp;
        if (n != 0) {
            return n;
        }
        n = this.realConfiguration.smallestScreenWidthDp - that.smallestScreenWidthDp;
        return n;
    }

    @Implementation
    public boolean equals(Configuration that) {
        if (that == null) {
            return false;
        }
        if (that == this.realConfiguration) {
            return true;
        }
        return this.realConfiguration.compareTo(that) == 0;
    }

    @Implementation
    public boolean equals(Object that) {
        try {
            return this.equals((Configuration)that);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Implementation
    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToIntBits(this.realConfiguration.fontScale);
        result = 31 * result + this.realConfiguration.mcc;
        result = 31 * result + this.realConfiguration.mnc;
        result = 31 * result + (this.realConfiguration.locale != null ? this.realConfiguration.locale.hashCode() : 0);
        result = 31 * result + this.touchscreen;
        result = 31 * result + this.realConfiguration.keyboard;
        result = 31 * result + this.realConfiguration.keyboardHidden;
        result = 31 * result + this.realConfiguration.hardKeyboardHidden;
        result = 31 * result + this.realConfiguration.navigation;
        result = 31 * result + this.realConfiguration.navigationHidden;
        result = 31 * result + this.orientation;
        result = 31 * result + this.screenLayout;
        result = 31 * result + this.realConfiguration.uiMode;
        result = 31 * result + this.realConfiguration.screenWidthDp;
        result = 31 * result + this.realConfiguration.screenHeightDp;
        result = 31 * result + this.realConfiguration.smallestScreenWidthDp;
        return result;
    }

    @Implementation
    public void setToDefaults() {
        ((Configuration)Shadow.directlyOn((Object)this.realConfiguration, Configuration.class)).setToDefaults();
        this.realConfiguration.screenLayout = 18;
    }

    @Implementation
    public void setLocale(Locale l) {
        this.realConfiguration.locale = l;
    }

    public void overrideQualifiers(String qualifiers) {
        this.qualifiers = qualifiers;
    }

    public String getQualifiers() {
        return this.qualifiers;
    }
}

