package org.robolectric.shadows;

import android.text.format.Time;
import android.util.TimeFormatException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.Strftime;
import org.robolectric.util.ReflectionHelpers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

/**
 * Shadow for {@link android.text.format.Time}.
 */
@Implements(Time.class)
public class ShadowTime {
  @RealObject
  private Time time;

  @Implementation
  public void setToNow() {
    time.set(ShadowSystemClock.currentTimeMillis());
  }

}
