/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.DownloadManager;
import android.database.Cursor;
import android.net.Uri;
import android.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.BaseCursor;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=DownloadManager.class)
public class ShadowDownloadManager {
    private long queueCounter = -1L;
    private Map<Long, DownloadManager.Request> requestMap = new HashMap<Long, DownloadManager.Request>();

    @Implementation
    public long enqueue(DownloadManager.Request request) {
        ++this.queueCounter;
        this.requestMap.put(this.queueCounter, request);
        return this.queueCounter;
    }

    @Implementation
    public int remove(long ... ids) {
        int removeCount = 0;
        for (long id2 : ids) {
            if (this.requestMap.remove(id2) == null) continue;
            ++removeCount;
        }
        return removeCount;
    }

    @Implementation
    public Cursor query(DownloadManager.Query query) {
        ResultCursor result = new ResultCursor();
        ShadowQuery shadow = Shadows.shadowOf(query);
        long[] ids = shadow.getIds();
        if (ids != null) {
            for (long id2 : ids) {
                DownloadManager.Request request = this.requestMap.get(id2);
                if (request == null) continue;
                result.requests.add(request);
            }
        }
        return result;
    }

    public DownloadManager.Request getRequest(long id2) {
        return this.requestMap.get(id2);
    }

    public int getRequestCount() {
        return this.requestMap.size();
    }

    private static <T> T getFieldReflectively(String fieldName, Object object, Class aClass) {
        return (T)ReflectionHelpers.getField((Object)object, (String)fieldName);
    }

    private class ResultCursor
    extends BaseCursor {
        private static final int COLUMN_INDEX_LOCAL_FILENAME = 0;
        private static final int COLUMN_INDEX_DESCRIPTION = 1;
        private static final int COLUMN_INDEX_REASON = 2;
        private static final int COLUMN_INDEX_STATUS = 3;
        private static final int COLUMN_INDEX_URI = 4;
        private static final int COLUMN_INDEX_LOCAL_URI = 5;
        public List<DownloadManager.Request> requests = new ArrayList<DownloadManager.Request>();
        private int positionIndex = -1;
        private boolean closed;

        private ResultCursor() {
        }

        @Override
        public int getCount() {
            this.checkClosed();
            return this.requests.size();
        }

        @Override
        public boolean moveToFirst() {
            this.checkClosed();
            this.positionIndex = 0;
            return !this.requests.isEmpty();
        }

        @Override
        public boolean moveToNext() {
            this.checkClosed();
            ++this.positionIndex;
            return this.positionIndex < this.requests.size();
        }

        @Override
        public int getColumnIndex(String columnName) {
            this.checkClosed();
            if ("local_filename".equals(columnName)) {
                return 0;
            }
            if ("description".equals(columnName)) {
                return 1;
            }
            if ("reason".equals(columnName)) {
                return 2;
            }
            if ("status".equals(columnName)) {
                return 3;
            }
            if ("uri".equals(columnName)) {
                return 4;
            }
            if ("local_uri".equals(columnName)) {
                return 5;
            }
            return -1;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public String getString(int columnIndex) {
            this.checkClosed();
            ShadowRequest request = Shadows.shadowOf(this.requests.get(this.positionIndex));
            switch (columnIndex) {
                case 0: {
                    return "local file name not implemented";
                }
                case 2: {
                    return "reason not implemented";
                }
                case 1: {
                    return request.getDescription().toString();
                }
                case 4: {
                    return request.getUri().toString();
                }
                case 5: {
                    return request.getDestination().toString();
                }
            }
            return "Unknown ColumnIndex " + columnIndex;
        }

        @Override
        public int getInt(int columnIndex) {
            this.checkClosed();
            ShadowRequest request = Shadows.shadowOf(this.requests.get(this.positionIndex));
            if (columnIndex == 3) {
                return request.getStatus();
            }
            return 0;
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Cursor is already closed.");
            }
        }
    }

    @Implements(value=DownloadManager.Query.class)
    public static class ShadowQuery {
        @RealObject
        DownloadManager.Query realObject;

        public long[] getIds() {
            return (long[])ShadowDownloadManager.getFieldReflectively("mIds", this.realObject, DownloadManager.Query.class);
        }
    }

    @Implements(value=DownloadManager.Request.class)
    public static class ShadowRequest {
        @RealObject
        DownloadManager.Request realObject;
        private int status;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public Uri getUri() {
            return (Uri)ShadowDownloadManager.getFieldReflectively("mUri", this.realObject, DownloadManager.Request.class);
        }

        public Uri getDestination() {
            return (Uri)ShadowDownloadManager.getFieldReflectively("mDestinationUri", this.realObject, DownloadManager.Request.class);
        }

        public CharSequence getTitle() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mTitle", this.realObject, DownloadManager.Request.class);
        }

        public CharSequence getDescription() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mDescription", this.realObject, DownloadManager.Request.class);
        }

        public CharSequence getMimeType() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mMimeType", this.realObject, DownloadManager.Request.class);
        }

        public int getNotificationVisibility() {
            return (Integer)ShadowDownloadManager.getFieldReflectively("mNotificationVisibility", this.realObject, DownloadManager.Request.class);
        }

        public int getAllowedNetworkTypes() {
            return (Integer)ShadowDownloadManager.getFieldReflectively("mAllowedNetworkTypes", this.realObject, DownloadManager.Request.class);
        }

        public boolean getAllowedOverRoaming() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mRoamingAllowed", this.realObject, DownloadManager.Request.class);
        }

        public boolean getAllowedOverMetered() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mMeteredAllowed", this.realObject, DownloadManager.Request.class);
        }

        public boolean getVisibleInDownloadsUi() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mIsVisibleInDownloadsUi", this.realObject, DownloadManager.Request.class);
        }

        public List<Pair<String, String>> getRequestHeaders() {
            return (List)ShadowDownloadManager.getFieldReflectively("mRequestHeaders", this.realObject, DownloadManager.Request.class);
        }
    }
}

