/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowView;

@Implements(value=ImageView.class)
public class ShadowImageView
extends ShadowView {
    private Drawable imageDrawable;
    private Bitmap imageBitmap;
    private ImageView.ScaleType scaleType;
    private Matrix matrix = new Matrix();
    private int imageLevel;

    @Implementation
    public void setImageBitmap(Bitmap imageBitmap) {
        this.setImageDrawable((Drawable)new BitmapDrawable(imageBitmap));
        this.imageBitmap = imageBitmap;
    }

    @Deprecated
    public Bitmap getImageBitmap() {
        return this.imageBitmap;
    }

    @Implementation
    public void setImageDrawable(Drawable drawable) {
        this.imageDrawable = drawable;
    }

    @Implementation
    public void setImageResource(int resId) {
        this.setImageDrawable(resId != 0 ? this.buildDrawable(resId) : null);
    }

    public int getImageResourceId() {
        ShadowDrawable shadow = Shadows.shadowOf(this.imageDrawable);
        return shadow.getCreatedFromResId();
    }

    @Implementation
    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    @Implementation
    public void setScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    @Implementation
    public Drawable getDrawable() {
        return this.imageDrawable;
    }

    @Implementation
    public void setImageMatrix(Matrix matrix) {
        this.matrix = new Matrix(matrix);
    }

    @Implementation
    public Matrix getImageMatrix() {
        return this.matrix;
    }

    @Override
    @Implementation
    public void draw(Canvas canvas) {
        if (this.imageDrawable != null) {
            this.imageDrawable.draw(canvas);
        }
    }

    @Implementation
    public void setImageLevel(int imageLevel) {
        this.imageLevel = imageLevel;
    }

    public int getImageLevel() {
        return this.imageLevel;
    }
}

