/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.Window;
import android.widget.ProgressBar;
import com.android.internal.policy.impl.PhoneWindow;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Window.class)
public class ShadowWindow {
    @RealObject
    private Window realWindow;
    private int flags;
    private int softInputMode;

    public static Window create(Context context) throws Exception {
        return new PhoneWindow(context);
    }

    @Implementation
    public void setFlags(int flags, int mask) {
        this.flags = this.flags & ~mask | flags & mask;
        Shadow.directlyOn((Object)this.realWindow, Window.class, (String)"setFlags", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mask)});
    }

    @Implementation
    public void setSoftInputMode(int softInputMode) {
        this.softInputMode = softInputMode;
        Shadow.directlyOn((Object)this.realWindow, Window.class, (String)"setSoftInputMode", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)softInputMode)});
    }

    public boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public CharSequence getTitle() {
        return "";
    }

    public Drawable getBackgroundDrawable() {
        return null;
    }

    public int getSoftInputMode() {
        return this.softInputMode;
    }

    public ProgressBar getProgressBar() {
        return null;
    }

    public ProgressBar getIndeterminateProgressBar() {
        return null;
    }
}

