/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.TypedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.res.ResName;

public final class ResourceHelper {
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]*(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f), new UnitEntry("%", 6, 0, 0.01f), new UnitEntry("%p", 6, 1, 0.01f)};

    public static int getColor(String value) {
        if (value != null) {
            if (!value.startsWith("#")) {
                throw new NumberFormatException(String.format("Color value '%s' must start with #", value));
            }
            if ((value = value.substring(1)).length() > 8) {
                throw new NumberFormatException(String.format("Color value '%s' is too long. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value));
            }
            if (value.length() == 3) {
                char[] color = new char[8];
                color[1] = 70;
                color[0] = 70;
                color[2] = color[3] = value.charAt(0);
                color[4] = color[5] = value.charAt(1);
                color[6] = color[7] = value.charAt(2);
                value = new String(color);
            } else if (value.length() == 4) {
                char[] color = new char[8];
                color[0] = color[1] = value.charAt(0);
                color[2] = color[3] = value.charAt(1);
                color[4] = color[5] = value.charAt(2);
                color[6] = color[7] = value.charAt(3);
                value = new String(color);
            } else if (value.length() == 6) {
                value = "FF" + value;
            }
            return (int)Long.parseLong(value, 16);
        }
        throw new NumberFormatException();
    }

    public static int getColorType(String value) {
        if (value != null && value.startsWith("#")) {
            switch (value.length()) {
                case 4: {
                    return 31;
                }
                case 5: {
                    return 30;
                }
                case 7: {
                    return 29;
                }
                case 9: {
                    return 28;
                }
            }
        }
        return 28;
    }

    public static int getInternalResourceId(String idName) {
        return RuntimeEnvironment.getSystemResourceTable().getResourceId(new ResName("android", "id", idName));
    }

    public static TypedValue getValue(String attribute, String value, boolean requireUnit) {
        if (ResourceHelper.parseFloatAttribute(attribute, value, mValue, requireUnit)) {
            return mValue;
        }
        return null;
    }

    public static boolean parseFloatAttribute(String attribute, String value, TypedValue outValue, boolean requireUnit) {
        assert (!requireUnit || attribute != null);
        int len = (value = value.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if (buf[0] < '0' && buf[0] > '9' && buf[0] != '.' && buf[0] != '-') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                outValue.assetCookie = 0;
                outValue.string = null;
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    System.out.println(String.format("Dimension \"%1$s\" in attribute \"%2$s\" is missing unit!", value, attribute));
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value *= scale) < 0.0f;
        if (neg) {
            value = -value;
        }
        if (((bits = (long)(value * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            ResourceHelper.applyUnit(unit, outValue, outScale);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue, float[] outScale) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        outScale[0] = unit.scale;
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

