/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Adapter;
import android.widget.FrameLayout;
import com.android.internal.app.AlertController;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAlertController;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AlertDialog.class)
public class ShadowAlertDialog
extends ShadowDialog {
    @RealObject
    private AlertDialog realAlertDialog;
    private CharSequence[] items;
    private DialogInterface.OnClickListener clickListener;
    private boolean isMultiItem;
    private boolean isSingleItem;
    private DialogInterface.OnMultiChoiceClickListener multiChoiceClickListener;
    private FrameLayout custom;

    public static AlertDialog getLatestAlertDialog() {
        ShadowAlertDialog dialog = Shadows.shadowOf(RuntimeEnvironment.application).getLatestAlertDialog();
        return dialog == null ? null : dialog.realAlertDialog;
    }

    public FrameLayout getCustomView() {
        if (this.custom == null) {
            this.custom = new FrameLayout(this.context);
        }
        return this.custom;
    }

    public static void reset() {
        Shadows.shadowOf(RuntimeEnvironment.application).setLatestAlertDialog(null);
    }

    public void clickOnItem(int index) {
        Shadows.shadowOf(this.realAlertDialog.getListView()).performItemClick(index);
    }

    @Override
    public CharSequence getTitle() {
        return this.getShadowAlertController().getTitle();
    }

    public CharSequence[] getItems() {
        Adapter adapter = this.getShadowAlertController().getAdapter();
        int count = adapter.getCount();
        CharSequence[] items = new CharSequence[count];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (CharSequence)adapter.getItem(i);
        }
        return items;
    }

    public Adapter getAdapter() {
        return this.getShadowAlertController().getAdapter();
    }

    public CharSequence getMessage() {
        return this.getShadowAlertController().getMessage();
    }

    @Override
    @Implementation
    public void show() {
        super.show();
        Shadows.shadowOf(RuntimeEnvironment.application).setLatestAlertDialog(this);
    }

    public View getView() {
        return this.getShadowAlertController().getView();
    }

    public View getCustomTitleView() {
        return this.getShadowAlertController().getCustomTitleView();
    }

    public ShadowAlertController getShadowAlertController() {
        AlertController alert = (AlertController)ReflectionHelpers.getField((Object)this.realAlertDialog, (String)"mAlert");
        return (ShadowAlertController)Shadow.extract((Object)alert);
    }

    @Implements(value=AlertDialog.Builder.class)
    public static class ShadowBuilder {
    }
}

