/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.UserManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowUserManager;

@Implements(value=DevicePolicyManager.class)
public class ShadowDevicePolicyManager {
    private static final int DEFAULT_ORGANIZATION_COLOR = -16744320;
    private ComponentName deviceOwner;
    private ComponentName profileOwner;
    private List<ComponentName> deviceAdmins = new ArrayList<ComponentName>();
    private List<String> permittedAccessibilityServices = new ArrayList<String>();
    private List<String> permittedInputMethods = new ArrayList<String>();
    private Map<String, Bundle> applicationRestrictionsMap = new HashMap<String, Bundle>();
    private CharSequence organizationName;
    private int organizationColor = -16744320;
    private boolean isAutoTimeRequired;
    private int storageEncryptionStatus = 0;
    private final Set<String> hiddenPackages = new HashSet<String>();
    private final Set<String> wasHiddenPackages = new HashSet<String>();
    private final Set<String> accountTypesWithManagementDisabled = new HashSet<String>();
    private final Set<String> systemAppsEnabled = new HashSet<String>();
    private final Set<String> uninstallBlockedPackages = new HashSet<String>();

    @Implementation
    public boolean isDeviceOwnerApp(String packageName) {
        return this.deviceOwner != null && this.deviceOwner.getPackageName().equals(packageName);
    }

    @Implementation
    public boolean isProfileOwnerApp(String packageName) {
        return this.profileOwner != null && this.profileOwner.getPackageName().equals(packageName);
    }

    @Implementation
    public boolean isAdminActive(ComponentName who) {
        return who != null && this.deviceAdmins.contains(who);
    }

    @Implementation
    public List<ComponentName> getActiveAdmins() {
        return this.deviceAdmins;
    }

    @Implementation
    public void addUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, true);
    }

    @Implementation
    public void clearUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, false);
    }

    @Implementation
    public void setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        this.enforceActiveAdmin(admin);
        if (hidden) {
            this.hiddenPackages.add(packageName);
            this.wasHiddenPackages.add(packageName);
        } else {
            this.hiddenPackages.remove(packageName);
        }
    }

    @Implementation
    public boolean isApplicationHidden(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        return this.hiddenPackages.contains(packageName);
    }

    public boolean wasPackageEverHidden(String packageName) {
        return this.wasHiddenPackages.contains(packageName);
    }

    @Implementation
    public int enableSystemApp(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        this.systemAppsEnabled.add(packageName);
        return 1;
    }

    public boolean wasSystemAppEnabled(String packageName) {
        return this.systemAppsEnabled.contains(packageName);
    }

    @Implementation
    public void setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        this.enforceActiveAdmin(admin);
        if (uninstallBlocked) {
            this.uninstallBlockedPackages.add(packageName);
        } else {
            this.uninstallBlockedPackages.remove(packageName);
        }
    }

    @Implementation
    public boolean isUninstallBlocked(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        return this.uninstallBlockedPackages.contains(packageName);
    }

    @Implementation(minSdk=18)
    protected String getDeviceOwner() {
        return this.deviceOwner != null ? this.deviceOwner.getPackageName() : null;
    }

    @Implementation(minSdk=21)
    protected ComponentName getProfileOwner() {
        return this.profileOwner;
    }

    private ShadowUserManager getShadowUserManager() {
        return Shadows.shadowOf((UserManager)RuntimeEnvironment.application.getSystemService("user"));
    }

    public void setDeviceOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        this.deviceOwner = admin;
    }

    public void setProfileOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        this.profileOwner = admin;
    }

    public void setActiveAdmin(ComponentName componentName) {
        this.deviceAdmins.add(componentName);
    }

    @Implementation
    public Bundle getApplicationRestrictions(ComponentName admin, String packageName) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.getApplicationRestrictions(packageName);
    }

    public Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = this.applicationRestrictionsMap.get(packageName);
        return bundle != null ? bundle : Bundle.EMPTY;
    }

    @Implementation
    public void setApplicationRestrictions(ComponentName admin, String packageName, Bundle applicationRestrictions) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.setApplicationRestrictions(packageName, applicationRestrictions);
    }

    public void setApplicationRestrictions(String packageName, Bundle applicationRestrictions) {
        this.applicationRestrictionsMap.put(packageName, applicationRestrictions);
    }

    private void enforceProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)this.profileOwner)) {
            throw new SecurityException("[" + admin + "] is not a profile owner");
        }
    }

    private void enforceDeviceOwner(ComponentName admin) {
        if (!admin.equals((Object)this.deviceOwner)) {
            throw new SecurityException("[" + admin + "] is not a device owner");
        }
    }

    private void enforceDeviceOwnerOrProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)this.deviceOwner) && !admin.equals((Object)this.profileOwner)) {
            throw new SecurityException("[" + admin + "] is neither a device owner nor a profile owner.");
        }
    }

    private void enforceActiveAdmin(ComponentName admin) {
        if (!this.deviceAdmins.contains(admin)) {
            throw new SecurityException("[" + admin + "] is not an active device admin");
        }
    }

    @Implementation
    public void setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (disabled) {
            this.accountTypesWithManagementDisabled.add(accountType);
        } else {
            this.accountTypesWithManagementDisabled.remove(accountType);
        }
    }

    @Implementation
    public String[] getAccountTypesWithManagementDisabled() {
        return this.accountTypesWithManagementDisabled.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    public void setOrganizationName(ComponentName admin, CharSequence name) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        this.organizationName = TextUtils.isEmpty((CharSequence)name) ? null : name;
    }

    @Implementation(minSdk=24)
    public void setOrganizationColor(ComponentName admin, int color) {
        this.enforceProfileOwner(admin);
        this.organizationColor = color;
    }

    @Implementation(minSdk=24)
    public CharSequence getOrganizationName(ComponentName admin) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        return this.organizationName;
    }

    @Implementation(minSdk=24)
    public int getOrganizationColor(ComponentName admin) {
        this.enforceProfileOwner(admin);
        return this.organizationColor;
    }

    @Implementation
    public void setAutoTimeRequired(ComponentName admin, boolean required) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.isAutoTimeRequired = required;
    }

    @Implementation
    public boolean getAutoTimeRequired() {
        return this.isAutoTimeRequired;
    }

    @Implementation
    public boolean setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedAccessibilityServices = packageNames;
        return true;
    }

    @Implementation
    public List<String> getPermittedAccessibilityServices(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedAccessibilityServices;
    }

    @Implementation
    public boolean setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedInputMethods = packageNames;
        return true;
    }

    @Implementation
    public List<String> getPermittedInputMethods(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedInputMethods;
    }

    @Implementation
    protected int getStorageEncryptionStatus() {
        return this.storageEncryptionStatus;
    }

    public void setStorageEncryptionStatus(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (RuntimeEnvironment.getApiLevel() >= 23) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 23);
            }
            case 5: {
                if (RuntimeEnvironment.getApiLevel() >= 24) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 24);
            }
            default: {
                throw new IllegalArgumentException("Unknown status: " + status);
            }
        }
        this.storageEncryptionStatus = status;
    }
}

