/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.os.Handler;
import android.util.Log;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=FingerprintManager.class)
public class ShadowFingerprintManager {
    private static final String TAG = "ShadowFingerprintManager";
    private boolean isHardwareDetected;
    private boolean hasEnrolledFingerprints;
    private FingerprintManager.CryptoObject pendingCryptoObject;
    private FingerprintManager.AuthenticationCallback pendingCallback;

    public void authenticationSucceeds() {
        if (this.pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        FingerprintManager.AuthenticationResult result = RuntimeEnvironment.getApiLevel() >= 25 ? new FingerprintManager.AuthenticationResult(this.pendingCryptoObject, null, 0) : (FingerprintManager.AuthenticationResult)ReflectionHelpers.callConstructor(FingerprintManager.AuthenticationResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FingerprintManager.CryptoObject.class, (Object)this.pendingCryptoObject), ReflectionHelpers.ClassParameter.from(Fingerprint.class, null)});
        this.pendingCallback.onAuthenticationSucceeded(result);
    }

    public void authenticationFails() {
        if (this.pendingCallback == null) {
            throw new IllegalStateException("No active fingerprint authentication request.");
        }
        this.pendingCallback.onAuthenticationFailed();
    }

    @Implementation
    protected void authenticate(FingerprintManager.CryptoObject crypto, CancellationSignal cancel, int flags, FingerprintManager.AuthenticationCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null) {
            if (cancel.isCanceled()) {
                Log.w((String)TAG, (String)"authentication already canceled");
                return;
            }
            cancel.setOnCancelListener(() -> {
                this.pendingCallback = null;
                this.pendingCryptoObject = null;
            });
        }
        this.pendingCryptoObject = crypto;
        this.pendingCallback = callback;
    }

    public void setHasEnrolledFingerprints(boolean hasEnrolledFingerprints) {
        this.hasEnrolledFingerprints = hasEnrolledFingerprints;
    }

    @Implementation
    protected boolean hasEnrolledFingerprints() {
        return this.hasEnrolledFingerprints;
    }

    public void setIsHardwareDetected(boolean isHardwareDetected) {
        this.isHardwareDetected = isHardwareDetected;
    }

    @Implementation
    protected boolean isHardwareDetected() {
        return this.isHardwareDetected;
    }
}

