/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Pair;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;

@Implements(value=PackageManager.class)
public class ShadowPackageManager {
    Map<String, Boolean> permissionRationaleMap = new HashMap<String, Boolean>();
    List<FeatureInfo> systemAvailableFeatures = new ArrayList<FeatureInfo>();
    final Map<String, PackageInfo> packageInfos = new LinkedHashMap<String, PackageInfo>();
    final Map<String, PackageParser.Package> packages = new LinkedHashMap<String, PackageParser.Package>();
    private Map<String, PackageInfo> packageArchiveInfo = new HashMap<String, PackageInfo>();
    final Map<String, PackageStats> packageStatsMap = new HashMap<String, PackageStats>();
    final Map<String, String> packageInstallerMap = new HashMap<String, String>();
    final Map<Integer, String[]> packagesForUid = new HashMap<Integer, String[]>();
    final Map<String, Integer> uidForPackage = new HashMap<String, Integer>();
    final Map<Integer, String> namesForUid = new HashMap<Integer, String>();
    final Map<Integer, Integer> verificationResults = new HashMap<Integer, Integer>();
    final Map<Integer, Long> verificationTimeoutExtension = new HashMap<Integer, Long>();
    final Map<String, String> currentToCanonicalNames = new HashMap<String, String>();
    final Map<ComponentName, ComponentState> componentList = new LinkedHashMap<ComponentName, ComponentState>();
    final Map<ComponentName, Drawable> drawableList = new LinkedHashMap<ComponentName, Drawable>();
    final Map<String, Drawable> applicationIcons = new HashMap<String, Drawable>();
    final Map<String, Boolean> systemFeatureList = new LinkedHashMap<String, Boolean>();
    final Map<IntentFilter, ComponentName> preferredActivities = new LinkedHashMap<IntentFilter, ComponentName>();
    final Map<Pair<String, Integer>, Drawable> drawables = new LinkedHashMap<Pair<String, Integer>, Drawable>();
    final Map<String, Integer> applicationEnabledSettingMap = new HashMap<String, Integer>();
    Map<String, PermissionInfo> extraPermissions = new HashMap<String, PermissionInfo>();
    Map<String, PermissionGroupInfo> extraPermissionGroups = new HashMap<String, PermissionGroupInfo>();
    public Map<String, Resources> resources = new HashMap<String, Resources>();
    private final Map<Intent, List<ResolveInfo>> resolveInfoForIntent = new TreeMap<Intent, List<ResolveInfo>>(new IntentComparator());
    private Set<String> deletedPackages = new HashSet<String>();
    Map<String, IPackageDeleteObserver> pendingDeleteCallbacks = new HashMap<String, IPackageDeleteObserver>();

    static int compareSignature(Signature[] signatures1, Signature[] signatures2) {
        HashSet<Signature> signatures2set;
        if (signatures1 == null) {
            return signatures2 == null ? 1 : -1;
        }
        if (signatures2 == null) {
            return -2;
        }
        if (signatures1.length != signatures2.length) {
            return -3;
        }
        HashSet<Signature> signatures1set = new HashSet<Signature>(Arrays.asList(signatures1));
        return signatures1set.equals(signatures2set = new HashSet<Signature>(Arrays.asList(signatures2))) ? 0 : -3;
    }

    static String resolvePackageName(String packageName, ComponentName componentName) {
        String classString = componentName.getClassName();
        int index = classString.indexOf(46);
        if (index == -1) {
            classString = packageName + "." + classString;
        } else if (index == 0) {
            classString = packageName + classString;
        }
        return classString;
    }

    private static void setUpPackageStorage(ApplicationInfo applicationInfo) {
        TempDirectory tempDirectory = RuntimeEnvironment.getTempDirectory();
        if (applicationInfo.sourceDir == null) {
            applicationInfo.sourceDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-sourceDir").toAbsolutePath().toString();
        }
        if (applicationInfo.dataDir == null) {
            applicationInfo.dataDir = tempDirectory.createIfNotExists(applicationInfo.packageName + "-dataDir").toAbsolutePath().toString();
        }
        applicationInfo.publicSourceDir = applicationInfo.sourceDir;
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            applicationInfo.credentialProtectedDataDir = tempDirectory.createIfNotExists("userDataDir").toAbsolutePath().toString();
            applicationInfo.deviceProtectedDataDir = tempDirectory.createIfNotExists("deviceDataDir").toAbsolutePath().toString();
        }
    }

    public void addResolveInfoForIntent(Intent intent, List<ResolveInfo> info) {
        this.resolveInfoForIntent.put(intent, info);
    }

    public void addResolveInfoForIntent(Intent intent, ResolveInfo info) {
        List<ResolveInfo> infoList = this.resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            this.resolveInfoForIntent.put(intent, infoList);
        }
        infoList.add(info);
    }

    public void removeResolveInfosForIntent(Intent intent, String packageName) {
        List<ResolveInfo> infoList = this.resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            this.resolveInfoForIntent.put(intent, infoList);
        }
        Iterator<ResolveInfo> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            ResolveInfo resolveInfo = iterator.next();
            if (!ShadowPackageManager.getPackageName(resolveInfo).equals(packageName)) continue;
            iterator.remove();
        }
    }

    private static String getPackageName(ResolveInfo resolveInfo) {
        if (resolveInfo.resolvePackageName != null) {
            return resolveInfo.resolvePackageName;
        }
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.packageName;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo.packageName;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo.packageName;
        }
        throw new IllegalStateException("Could not find package name for ResolveInfo " + resolveInfo.toString());
    }

    public void addActivityIcon(ComponentName component, Drawable drawable) {
        this.drawableList.put(component, drawable);
    }

    public void addActivityIcon(Intent intent, Drawable drawable) {
        this.drawableList.put(intent.getComponent(), drawable);
    }

    public void setApplicationIcon(String packageName, Drawable drawable) {
        this.applicationIcons.put(packageName, drawable);
    }

    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.preferredActivities.put(filter, activity);
    }

    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (outFilters == null) {
            return 0;
        }
        Set<IntentFilter> filters = this.preferredActivities.keySet();
        for (IntentFilter filter : outFilters) {
            block1: for (IntentFilter testFilter : filters) {
                ComponentName name = this.preferredActivities.get(testFilter);
                if (packageName != null && !name.getPackageName().equals(packageName)) continue;
                Iterator iterator = filter.actionsIterator();
                while (iterator.hasNext()) {
                    if (testFilter.matchAction((String)iterator.next())) continue;
                    continue block1;
                }
                iterator = filter.categoriesIterator();
                while (iterator.hasNext()) {
                    if (filter.hasCategory((String)iterator.next())) continue;
                    continue block1;
                }
                if (outActivities == null) {
                    outActivities = new ArrayList<ComponentName>();
                }
                outActivities.add(name);
            }
        }
        return 0;
    }

    public int getComponentEnabledSettingFlags(ComponentName componentName) {
        ComponentState state = this.componentList.get(componentName);
        return state != null ? state.flags : 0;
    }

    @Deprecated
    public void addPackage(String packageName) {
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = packageName;
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = packageName;
        ShadowPackageManager.setUpPackageStorage(applicationInfo);
        packageInfo.applicationInfo = applicationInfo;
        this.addPackage(packageInfo);
    }

    public void addPackage(PackageInfo packageInfo) {
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        this.addPackage(packageInfo, packageStats);
    }

    public void addPackage(PackageInfo packageInfo, PackageStats packageStats) {
        Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
        this.packageInfos.put(packageInfo.packageName, packageInfo);
        this.packageStatsMap.put(packageInfo.packageName, packageStats);
        this.applicationEnabledSettingMap.put(packageInfo.packageName, 0);
        if (packageInfo.applicationInfo != null) {
            this.namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
        }
    }

    public void addPermissionInfo(PermissionInfo permissionInfo) {
        this.extraPermissions.put(permissionInfo.name, permissionInfo);
    }

    public void addPermissionGroupInfo(PermissionGroupInfo permissionGroupInfo) {
        this.extraPermissionGroups.put(permissionGroupInfo.name, permissionGroupInfo);
    }

    public void removePackage(String packageName) {
        this.packages.remove(packageName);
        this.packageInfos.remove(packageName);
    }

    public void setSystemFeature(String name, boolean supported) {
        this.systemFeatureList.put(name, supported);
    }

    public void addDrawableResolution(String packageName, int resourceId, Drawable drawable) {
        this.drawables.put((Pair<String, Integer>)new Pair((Object)packageName, (Object)resourceId), drawable);
    }

    public void setNameForUid(int uid, String name) {
        this.namesForUid.put(uid, name);
    }

    public void setPackagesForCallingUid(String ... packagesForCallingUid) {
        this.packagesForUid.put(Binder.getCallingUid(), packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            this.uidForPackage.put(packageName, Binder.getCallingUid());
        }
    }

    public void setPackagesForUid(int uid, String ... packagesForCallingUid) {
        this.packagesForUid.put(uid, packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            this.uidForPackage.put(packageName, uid);
        }
    }

    public void setPackageArchiveInfo(String archiveFilePath, PackageInfo packageInfo) {
        this.packageArchiveInfo.put(archiveFilePath, packageInfo);
    }

    public int getVerificationResult(int id2) {
        Integer result = this.verificationResults.get(id2);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public long getVerificationExtendedTimeout(int id2) {
        Long result = this.verificationTimeoutExtension.get(id2);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public void setShouldShowRequestPermissionRationale(String permission2, boolean show) {
        this.permissionRationaleMap.put(permission2, show);
    }

    public void addSystemAvailableFeature(FeatureInfo featureInfo) {
        this.systemAvailableFeatures.add(featureInfo);
    }

    public void clearSystemAvailableFeatures() {
        this.systemAvailableFeatures.clear();
    }

    public void addCurrentToCannonicalName(String currentName, String canonicalName) {
        this.currentToCanonicalNames.put(currentName, canonicalName);
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, UserHandle userHandle) {
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (this.applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192) continue;
            result.add(packageInfo);
        }
        ArrayList<PackageInfo> packages = result;
        for (PackageInfo aPackage : packages) {
            ApplicationInfo appInfo = aPackage.applicationInfo;
            if (appInfo == null || !archiveFilePath.equals(appInfo.sourceDir)) continue;
            return aPackage;
        }
        return null;
    }

    @Implementation
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void freeStorage(long freeStorageSize, IntentSender pi) {
    }

    public void doPendingUninstallCallbacks() {
        boolean hasDeletePackagesPermission = false;
        String[] requestedPermissions = this.packageInfos.get((Object)RuntimeEnvironment.application.getPackageName()).requestedPermissions;
        if (requestedPermissions != null) {
            for (String permission2 : requestedPermissions) {
                if (!"android.permission.DELETE_PACKAGES".equals(permission2)) continue;
                hasDeletePackagesPermission = true;
                break;
            }
        }
        for (String packageName : this.pendingDeleteCallbacks.keySet()) {
            int resultCode = -1;
            PackageInfo removed = this.packageInfos.get(packageName);
            if (hasDeletePackagesPermission && removed != null) {
                this.packageInfos.remove(packageName);
                this.deletedPackages.add(packageName);
                resultCode = 1;
            }
            try {
                this.pendingDeleteCallbacks.get(packageName).packageDeleted(packageName, resultCode);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
        this.pendingDeleteCallbacks.clear();
    }

    public Set<String> getDeletedPackages() {
        return this.deletedPackages;
    }

    protected List<ResolveInfo> queryOverriddenIntents(Intent intent, int flags) {
        List<ResolveInfo> result = this.resolveInfoForIntent.get(intent);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void addPackageInternal(PackageParser.Package appPackage) {
        int flags = 851967;
        this.packages.put(appPackage.packageName, appPackage);
        PackageInfo packageInfo = RuntimeEnvironment.getApiLevel() >= 23 ? PackageParser.generatePackageInfo((PackageParser.Package)appPackage, (int[])new int[]{0}, (int)flags, (long)0L, (long)0L, new HashSet(), (PackageUserState)new PackageUserState()) : (RuntimeEnvironment.getApiLevel() >= 22 ? (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(ArraySet.class, (Object)new ArraySet()), ReflectionHelpers.ClassParameter.from(PackageUserState.class, (Object)new PackageUserState())}) : (RuntimeEnvironment.getApiLevel() >= 17 ? (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(HashSet.class, new HashSet()), ReflectionHelpers.ClassParameter.from(PackageUserState.class, (Object)new PackageUserState())}) : (PackageInfo)ReflectionHelpers.callStaticMethod(PackageParser.class, (String)"generatePackageInfo", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)appPackage), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[]{0}), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(HashSet.class, new HashSet())})));
        packageInfo.applicationInfo.uid = Process.myUid();
        this.addPackage(packageInfo);
    }

    public List<IntentFilter> getIntentFiltersForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(this.getAppPackage((ComponentName)componentName).activities, componentName);
    }

    public List<IntentFilter> getIntentFiltersForService(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(this.getAppPackage((ComponentName)componentName).services, componentName);
    }

    public List<IntentFilter> getIntentFiltersForReceiver(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return ShadowPackageManager.getIntentFiltersForComponent(this.getAppPackage((ComponentName)componentName).receivers, componentName);
    }

    private static List<IntentFilter> getIntentFiltersForComponent(List<? extends PackageParser.Component> components, ComponentName componentName) throws PackageManager.NameNotFoundException {
        for (PackageParser.Component component : components) {
            if (!component.getComponentName().equals((Object)componentName)) continue;
            return component.intents;
        }
        throw new PackageManager.NameNotFoundException("unknown component " + componentName);
    }

    private PackageParser.Package getAppPackage(ComponentName componentName) throws PackageManager.NameNotFoundException {
        PackageParser.Package appPackage = this.packages.get(componentName.getPackageName());
        if (appPackage == null) {
            throw new PackageManager.NameNotFoundException("unknown package " + componentName.getPackageName());
        }
        return appPackage;
    }

    private static List<IntentFilter> convertIntentFilters(List<? extends PackageParser.IntentInfo> intentInfos) {
        ArrayList<IntentFilter> intentFilters = new ArrayList<IntentFilter>(intentInfos.size());
        for (PackageParser.IntentInfo intentInfo : intentInfos) {
            intentFilters.add((IntentFilter)intentInfo);
        }
        return intentFilters;
    }

    protected static class ComponentState {
        public int newState;
        public int flags;

        public ComponentState(int newState, int flags) {
            this.newState = newState;
            this.flags = flags;
        }
    }

    public static class IntentComparator
    implements Comparator<Intent> {
        @Override
        public int compare(Intent i1, Intent i2) {
            if (i1 == null && i2 == null) {
                return 0;
            }
            if (i1 == null && i2 != null) {
                return -1;
            }
            if (i1 != null && i2 == null) {
                return 1;
            }
            if (i1.equals(i2)) {
                return 0;
            }
            String action1 = i1.getAction();
            String action2 = i2.getAction();
            if (action1 == null && action2 != null) {
                return -1;
            }
            if (action1 != null && action2 == null) {
                return 1;
            }
            if (action1 != null && action2 != null && !action1.equals(action2)) {
                return action1.compareTo(action2);
            }
            Uri data1 = i1.getData();
            Uri data2 = i2.getData();
            if (data1 == null && data2 != null) {
                return -1;
            }
            if (data1 != null && data2 == null) {
                return 1;
            }
            if (data1 != null && data2 != null && !data1.equals((Object)data2)) {
                return data1.compareTo(data2);
            }
            ComponentName component1 = i1.getComponent();
            ComponentName component2 = i2.getComponent();
            if (component1 == null && component2 != null) {
                return -1;
            }
            if (component1 != null && component2 == null) {
                return 1;
            }
            if (component1 != null && component2 != null && !component1.equals((Object)component2)) {
                return component1.compareTo(component2);
            }
            String package1 = i1.getPackage();
            String package2 = i2.getPackage();
            if (package1 == null && package2 != null) {
                return -1;
            }
            if (package1 != null && package2 == null) {
                return 1;
            }
            if (package1 != null && package2 != null && !package1.equals(package2)) {
                return package1.compareTo(package2);
            }
            Set categories1 = i1.getCategories();
            Set categories2 = i2.getCategories();
            if (categories1 == null) {
                return categories2 == null ? 0 : -1;
            }
            if (categories2 == null) {
                return 1;
            }
            if (categories1.size() > categories2.size()) {
                return 1;
            }
            if (categories1.size() < categories2.size()) {
                return -1;
            }
            Object[] array1 = categories1.toArray(new String[0]);
            Object[] array2 = categories2.toArray(new String[0]);
            Arrays.sort(array1);
            Arrays.sort(array2);
            for (int i = 0; i < array1.length; ++i) {
                int val = ((String)array1[i]).compareTo((String)array2[i]);
                if (val == 0) continue;
                return val;
            }
            return 0;
        }
    }
}

