/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.IAccountManager;
import android.app.IAlarmManager;
import android.app.ISearchManager;
import android.app.admin.IDevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.trust.ITrustManager;
import android.content.IClipboard;
import android.content.IRestrictionsManager;
import android.content.pm.IShortcutService;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.input.IInputManager;
import android.hardware.usb.IUsbManager;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.net.IConnectivityManager;
import android.net.INetworkScoreService;
import android.net.nsd.INsdManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.os.Binder;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPowerManager;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.view.IInputMethodManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ServiceManager.class, isInAndroidSdk=false)
public class ShadowServiceManager {
    private static Map<String, IBinder> SERVICES = new HashMap<String, IBinder>(){
        {
            this.put("clipboard", ShadowServiceManager.createBinder(IClipboard.class, "android.content.IClipboard"));
            this.put("wifip2p", ShadowServiceManager.createBinder(IWifiP2pManager.class, "android.net.wifi.p2p.IWifiP2pManager"));
            this.put("account", ShadowServiceManager.createBinder(IAccountManager.class, "android.accounts.IAccountManager"));
            this.put("usb", ShadowServiceManager.createBinder(IUsbManager.class, "android.hardware.usb.IUsbManager"));
            this.put("location", ShadowServiceManager.createBinder(ILocationManager.class, "android.location.ILocationManager"));
            this.put("input_method", ShadowServiceManager.createBinder(IInputMethodManager.class, "com.android.internal.view.IInputMethodManager"));
            this.put("alarm", ShadowServiceManager.createBinder(IAlarmManager.class, "android.app.IAlarmManager"));
            this.put("power", ShadowServiceManager.createBinder(IPowerManager.class, "android.os.IPowerManager"));
            this.put("batterystats", ShadowServiceManager.createBinder(IBatteryStats.class, "com.android.internal.app.IBatteryStats"));
            this.put("dropbox", ShadowServiceManager.createBinder(IDropBoxManagerService.class, "com.android.internal.os.IDropBoxManagerService"));
            this.put("device_policy", ShadowServiceManager.createBinder(IDevicePolicyManager.class, "android.app.admin.IDevicePolicyManager"));
            this.put("connectivity", ShadowServiceManager.createBinder(IConnectivityManager.class, "android.net.IConnectivityManager"));
            this.put("wifi", ShadowServiceManager.createBinder(IWifiManager.class, "android.net.wifi.IWifiManager"));
            this.put("search", ShadowServiceManager.createBinder(ISearchManager.class, "android.app.ISearchManager"));
            this.put("uimode", ShadowServiceManager.createBinder(ISearchManager.class, "android.app.IUiModeManager"));
            this.put("netpolicy", ShadowServiceManager.createBinder(ISearchManager.class, "android.net.INetworkPolicyManager"));
            this.put("input", ShadowServiceManager.createBinder(IInputManager.class, "android.net.IInputManager"));
            this.put("country_detector", ShadowServiceManager.createBinder(ICountryDetector.class, "android.location.ICountryDetector"));
            this.put("servicediscovery", ShadowServiceManager.createBinder(INsdManager.class, "android.net.nsd.INsdManagerandroi"));
            if (RuntimeEnvironment.getApiLevel() >= 17) {
                this.put("user", ShadowServiceManager.createBinder(IUserManager.class, "android.os.IUserManager"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 18) {
                this.put("appops", ShadowServiceManager.createBinder(IAppOpsService.class, "com.android.internal.app.IAppOpsService"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 19) {
                this.put("batteryproperties", ShadowServiceManager.createBinder(IBatteryPropertiesRegistrar.class, "android.os.IBatteryPropertiesRegistrar"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                this.put("restrictions", ShadowServiceManager.createBinder(IRestrictionsManager.class, "android.content.IRestrictionsManager"));
                this.put("trust", ShadowServiceManager.createBinder(ITrustManager.class, "android.app.trust.ITrustManager"));
                this.put("jobscheduler", ShadowServiceManager.createBinder(IJobScheduler.class, "android.app.job.IJobScheduler"));
                this.put("network_score", ShadowServiceManager.createBinder(INetworkScoreService.class, "android.net.INetworkScoreService"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 23) {
                this.put("fingerprint", ShadowServiceManager.createBinder(IFingerprintService.class, "android.hardware.fingerprint.IFingerprintService"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 25) {
                this.put("shortcut", ShadowServiceManager.createBinder(IShortcutService.class, "android.content.pm.IShortcutService"));
            }
            if (RuntimeEnvironment.getApiLevel() >= 26) {
                this.put("mount", ShadowServiceManager.createBinder(IStorageManager.class, "android.os.storage.IStorageManager"));
            } else {
                this.put("mount", ShadowServiceManager.createBinder("android.os.storage.IMountService", "android.os.storage.IMountService"));
            }
        }
    };

    @Implementation
    public static IBinder getService(String name) {
        return SERVICES.get(name);
    }

    private static Binder createBinder(String className, String descriptor) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Binder binder = new Binder();
        binder.attachInterface((IInterface)ReflectionHelpers.createNullProxy(clazz), descriptor);
        return binder;
    }

    private static Binder createBinder(Class<? extends IInterface> clazz, String descriptor) {
        Binder binder = new Binder();
        binder.attachInterface((IInterface)ReflectionHelpers.createNullProxy(clazz), descriptor);
        return binder;
    }

    @Implementation
    public static void addService(String name, IBinder service) {
    }

    @Implementation
    public static IBinder checkService(String name) {
        return null;
    }

    @Implementation
    public static String[] listServices() throws RemoteException {
        return null;
    }

    @Implementation
    public static void initServiceCache(Map<String, IBinder> cache) {
    }
}

