/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=TextToSpeech.class)
public class ShadowTextToSpeech {
    private Context context;
    private TextToSpeech.OnInitListener listener;
    private String lastSpokenText;
    private boolean shutdown = false;
    private boolean stopped = true;
    private int queueMode = -1;

    @Implementation
    public void __constructor__(Context context, TextToSpeech.OnInitListener listener) {
        this.context = context;
        this.listener = listener;
    }

    @Implementation
    public int speak(String text, int queueMode, HashMap<String, String> params) {
        this.stopped = false;
        this.lastSpokenText = text;
        this.queueMode = queueMode;
        return 0;
    }

    @Implementation
    protected int speak(CharSequence text, int queueMode, Bundle params, String utteranceId) {
        return this.speak(text.toString(), queueMode, new HashMap<String, String>());
    }

    @Implementation
    public void shutdown() {
        this.shutdown = true;
    }

    @Implementation
    protected int stop() {
        this.stopped = true;
        return 0;
    }

    public Context getContext() {
        return this.context;
    }

    public TextToSpeech.OnInitListener getOnInitListener() {
        return this.listener;
    }

    public String getLastSpokenText() {
        return this.lastSpokenText;
    }

    public void clearLastSpokenText() {
        this.lastSpokenText = null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getQueueMode() {
        return this.queueMode;
    }
}

