/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.telephony.SubscriptionManager;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsMmTelManager;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.feature.MmTelFeature;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.Map;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=ImsMmTelManager.class, minSdk=29, looseSignatures=true, isInAndroidSdk=false)
@SystemApi
public class ShadowImsMmTelManager {
    private static final Map<Integer, ImsMmTelManager> existingInstances = new ArrayMap();
    private final Map<ImsMmTelManager.RegistrationCallback, Executor> registrationCallbackExecutorMap = new ArrayMap();
    private final Map<ImsMmTelManager.CapabilityCallback, Executor> capabilityCallbackExecutorMap = new ArrayMap();
    private boolean imsAvailableOnDevice = true;
    private MmTelFeature.MmTelCapabilities mmTelCapabilitiesAvailable = new MmTelFeature.MmTelCapabilities();
    private int imsRegistrationTech = -1;
    private int subId;

    @Implementation
    protected void __constructor__(int subId) {
        this.subId = subId;
    }

    public void setImsAvailableOnDevice(boolean imsAvailableOnDevice) {
        this.imsAvailableOnDevice = imsAvailableOnDevice;
    }

    @Implementation
    protected void registerImsRegistrationCallback(@NonNull Executor executor, @NonNull ImsMmTelManager.RegistrationCallback c) throws ImsException {
        if (!this.imsAvailableOnDevice) {
            throw new ImsException("IMS not available on device.", 2);
        }
        this.registrationCallbackExecutorMap.put(c, executor);
    }

    @Implementation
    protected void unregisterImsRegistrationCallback(@NonNull ImsMmTelManager.RegistrationCallback c) {
        this.registrationCallbackExecutorMap.remove(c);
    }

    public void setImsRegistering(int imsRegistrationTech) {
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onRegistering(imsRegistrationTech));
        }
    }

    public void setImsRegistered(int imsRegistrationTech) {
        this.imsRegistrationTech = imsRegistrationTech;
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onRegistered(imsRegistrationTech));
        }
    }

    public void setImsUnregistered(@NonNull ImsReasonInfo imsReasonInfo) {
        this.imsRegistrationTech = -1;
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onUnregistered(imsReasonInfo));
        }
    }

    @Implementation
    protected void registerMmTelCapabilityCallback(@NonNull Executor executor, @NonNull ImsMmTelManager.CapabilityCallback c) throws ImsException {
        if (!this.imsAvailableOnDevice) {
            throw new ImsException("IMS not available on device.", 2);
        }
        this.capabilityCallbackExecutorMap.put(c, executor);
    }

    @Implementation
    protected void unregisterMmTelCapabilityCallback(@NonNull ImsMmTelManager.CapabilityCallback c) {
        this.capabilityCallbackExecutorMap.remove(c);
    }

    @Implementation
    protected boolean isAvailable(int capability, int imsRegTech) {
        return this.mmTelCapabilitiesAvailable.isCapable(capability) && imsRegTech == this.imsRegistrationTech;
    }

    public void setMmTelCapabilitiesAvailable(@NonNull MmTelFeature.MmTelCapabilities capabilities) {
        this.mmTelCapabilitiesAvailable = capabilities;
        if (this.imsRegistrationTech != -1) {
            for (Map.Entry<ImsMmTelManager.CapabilityCallback, Executor> entry : this.capabilityCallbackExecutorMap.entrySet()) {
                entry.getValue().execute(() -> ((ImsMmTelManager.CapabilityCallback)entry.getKey()).onCapabilitiesStatusChanged(capabilities));
            }
        }
    }

    public int getSubscriptionId() {
        return this.subId;
    }

    @Implementation
    @RequiresApi(api=29)
    protected static ImsMmTelManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId((int)subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        if (existingInstances.containsKey(subId)) {
            return existingInstances.get(subId);
        }
        ImsMmTelManager imsMmTelManager = new ImsMmTelManager(subId);
        existingInstances.put(subId, imsMmTelManager);
        return imsMmTelManager;
    }

    @Resetter
    public static void clearExistingInstances() {
        existingInstances.clear();
    }
}

