/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.AsyncTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowAsyncTask;
import org.robolectric.shadows.ShadowAsyncTaskBridge;

@Implements(value=AsyncTask.class, shadowPicker=ShadowAsyncTask.Picker.class, isInAndroidSdk=false)
public class ShadowLegacyAsyncTask<Params, Progress, Result>
extends ShadowAsyncTask {
    @RealObject
    private AsyncTask<Params, Progress, Result> realAsyncTask;
    private final FutureTask<Result> future;
    private final BackgroundWorker worker;
    private AsyncTask.Status status = AsyncTask.Status.PENDING;

    public ShadowLegacyAsyncTask() {
        this.worker = new BackgroundWorker();
        this.future = new FutureTask<Result>(this.worker){

            @Override
            protected void done() {
                ShadowLegacyAsyncTask.this.status = AsyncTask.Status.FINISHED;
                try {
                    final Object result = this.get();
                    try {
                        ShadowApplication.getInstance().getForegroundThreadScheduler().post(new Runnable(){

                            @Override
                            public void run() {
                                ShadowLegacyAsyncTask.this.getBridge().onPostExecute(result);
                            }
                        });
                    }
                    catch (Throwable t) {
                        throw new OnPostExecuteException(t);
                    }
                }
                catch (CancellationException e) {
                    ShadowApplication.getInstance().getForegroundThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowLegacyAsyncTask.this.getBridge().onCancelled();
                        }
                    });
                }
                catch (InterruptedException e) {
                }
                catch (OnPostExecuteException e) {
                    throw new RuntimeException(e.getCause());
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", t.getCause());
                }
            }
        };
    }

    @Implementation
    protected boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Implementation
    protected boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Implementation
    protected Result get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Implementation
    protected Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Implementation
    protected AsyncTask<Params, Progress, Result> execute(Params ... params) {
        this.status = AsyncTask.Status.RUNNING;
        this.getBridge().onPreExecute();
        this.worker.params = params;
        ShadowApplication.getInstance().getBackgroundThreadScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowLegacyAsyncTask.this.future.run();
            }
        });
        return this.realAsyncTask;
    }

    @Implementation
    protected AsyncTask<Params, Progress, Result> executeOnExecutor(Executor executor, Params ... params) {
        this.status = AsyncTask.Status.RUNNING;
        this.getBridge().onPreExecute();
        this.worker.params = params;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ShadowLegacyAsyncTask.this.future.run();
            }
        });
        return this.realAsyncTask;
    }

    @Implementation
    protected AsyncTask.Status getStatus() {
        return this.status;
    }

    @Implementation
    protected void publishProgress(final Progress ... values) {
        ShadowApplication.getInstance().getForegroundThreadScheduler().post(new Runnable(){

            @Override
            public void run() {
                ShadowLegacyAsyncTask.this.getBridge().onProgressUpdate(values);
            }
        });
    }

    private ShadowAsyncTaskBridge<Params, Progress, Result> getBridge() {
        return new ShadowAsyncTaskBridge<Params, Progress, Result>(this.realAsyncTask);
    }

    private static class OnPostExecuteException
    extends Exception {
        public OnPostExecuteException(Throwable throwable) {
            super(throwable);
        }
    }

    private final class BackgroundWorker
    implements Callable<Result> {
        Params[] params;

        private BackgroundWorker() {
        }

        @Override
        public Result call() throws Exception {
            return ShadowLegacyAsyncTask.this.getBridge().doInBackground(this.params);
        }
    }
}

