/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.media.MediaScannerConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=MediaScannerConnection.class)
public class ShadowMediaScannerConnection {
    private static final Set<String> savedPaths = new HashSet<String>();
    private static final Set<String> savedMimeTypes = new HashSet<String>();

    @Implementation
    protected static void scanFile(Context context, String[] paths, String[] mimeTypes, MediaScannerConnection.OnScanCompletedListener callback) {
        if (paths != null) {
            Collections.addAll(savedPaths, paths);
        }
        if (mimeTypes != null) {
            Collections.addAll(savedMimeTypes, mimeTypes);
        }
    }

    @Resetter
    public static void reset() {
        savedPaths.clear();
        savedMimeTypes.clear();
    }

    public static Set<String> getSavedPaths() {
        return new HashSet<String>(savedPaths);
    }

    public static Set<String> getSavedMimeTypes() {
        return new HashSet<String>(savedMimeTypes);
    }
}

